/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.parser.netty;

import io.moquette.parser.netty.MQTTDecoder;
import io.moquette.proto.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.util.Attribute;
import io.netty.util.AttributeMap;
import java.io.UnsupportedEncodingException;
import org.slf4j.LoggerFactory;

public class Utils {
    public static final int MAX_LENGTH_LIMIT = 0xFFFFFFF;
    public static final byte VERSION_3_1 = 3;
    public static final byte VERSION_3_1_1 = 4;

    static byte readMessageType(ByteBuf in) {
        byte h1 = in.readByte();
        byte messageType = (byte)((h1 & 0xF0) >> 4);
        return messageType;
    }

    static boolean checkHeaderAvailability(ByteBuf in) {
        if (in.readableBytes() < 1) {
            return false;
        }
        in.skipBytes(1);
        int remainingLength = Utils.decodeRemainingLenght(in);
        if (remainingLength == -1) {
            return false;
        }
        return in.readableBytes() >= remainingLength;
    }

    static int decodeRemainingLenght(ByteBuf in) {
        byte digit;
        int multiplier = 1;
        int value = 0;
        do {
            if (in.readableBytes() < 1) {
                return -1;
            }
            digit = in.readByte();
            value += (digit & 0x7F) * multiplier;
            multiplier *= 128;
        } while ((digit & 0x80) != 0);
        return value;
    }

    static ByteBuf encodeRemainingLength(int value) throws CorruptedFrameException {
        if (value > 0xFFFFFFF || value < 0) {
            throw new CorruptedFrameException("Value should in range 0..268435455 found " + value);
        }
        ByteBuf encoded = Unpooled.buffer(4);
        do {
            byte digit = (byte)(value % 128);
            if ((value /= 128) > 0) {
                digit = (byte)(digit | 0x80);
            }
            encoded.writeByte(digit);
        } while (value > 0);
        return encoded;
    }

    static String decodeString(ByteBuf in) throws UnsupportedEncodingException {
        return new String(Utils.readFixedLengthContent(in), "UTF-8");
    }

    static byte[] readFixedLengthContent(ByteBuf in) throws UnsupportedEncodingException {
        if (in.readableBytes() < 2) {
            return null;
        }
        int strLen = in.readUnsignedShort();
        if (in.readableBytes() < strLen) {
            return null;
        }
        byte[] strRaw = new byte[strLen];
        in.readBytes(strRaw);
        return strRaw;
    }

    public static ByteBuf encodeString(String str) {
        byte[] raw;
        try {
            raw = str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            LoggerFactory.getLogger(Utils.class).error(null, ex);
            return null;
        }
        return Utils.encodeFixedLengthContent(raw);
    }

    public static ByteBuf encodeFixedLengthContent(byte[] content) {
        ByteBuf out = Unpooled.buffer(2);
        out.writeShort(content.length);
        out.writeBytes(content);
        return out;
    }

    static int numBytesToEncode(int len) {
        if (0 <= len && len <= 127) {
            return 1;
        }
        if (128 <= len && len <= 16383) {
            return 2;
        }
        if (16384 <= len && len <= 0x1FFFFF) {
            return 3;
        }
        if (0x200000 <= len && len <= 0xFFFFFFF) {
            return 4;
        }
        throw new IllegalArgumentException("value shoul be in the range [0..268435455]");
    }

    static byte encodeFlags(AbstractMessage message) {
        byte flags = 0;
        if (message.isDupFlag()) {
            flags = (byte)(flags | 8);
        }
        if (message.isRetainFlag()) {
            flags = (byte)(flags | 1);
        }
        flags = (byte)(flags | (message.getQos().byteValue() & 3) << 1);
        return flags;
    }

    static boolean isMQTT3_1_1(AttributeMap attrsMap) {
        Attribute<Integer> versionAttr = attrsMap.attr(MQTTDecoder.PROTOCOL_VERSION);
        Integer protocolVersion = versionAttr.get();
        if (protocolVersion == null) {
            return true;
        }
        return protocolVersion == 4;
    }
}

