/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.kura.web.server.OsgiRemoteServiceServlet;
import org.eclipse.kura.web.shared.ForwardedEventTopic;
import org.eclipse.kura.web.shared.model.GwtEventInfo;
import org.eclipse.kura.web.shared.service.GwtEventService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class GwtEventServiceImpl
extends OsgiRemoteServiceServlet
implements GwtEventService,
EventHandler {
    private static final long serialVersionUID = 4948177265652519828L;
    private static final int MAX_EVENT_COUNT = 50;
    private LinkedList<String> topics = new LinkedList();
    private LinkedList<GwtEventInfo> events = new LinkedList();
    private ServiceRegistration<EventHandler> registration;

    public GwtEventServiceImpl() {
        ForwardedEventTopic[] forwardedEventTopicArray = ForwardedEventTopic.values();
        int n = forwardedEventTopicArray.length;
        int n2 = 0;
        while (n2 < n) {
            ForwardedEventTopic topic = forwardedEventTopicArray[n2];
            this.topics.add(topic.toString());
            ++n2;
        }
    }

    public synchronized void handleEvent(Event event) {
        GwtEventInfo eventInfo = this.serialize(event);
        if (this.events.size() >= 50) {
            this.events.removeLast();
        }
        this.events.push(eventInfo);
        this.notifyAll();
    }

    private List<GwtEventInfo> getEvents(long fromTimestamp) {
        LinkedList<GwtEventInfo> result = new LinkedList<GwtEventInfo>();
        for (GwtEventInfo next : this.events) {
            if (Long.parseLong(next.getTimestamp()) <= fromTimestamp) break;
            result.push(next);
        }
        return result;
    }

    public void start() {
        this.stop();
        Hashtable<String, String[]> map = new Hashtable<String, String[]>();
        ((Dictionary)map).put("event.topics", this.topics.toArray(new String[this.topics.size()]));
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        this.registration = bundleContext.registerService(EventHandler.class, (Object)this, map);
    }

    public void stop() {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
    }

    @Override
    public synchronized List<GwtEventInfo> getNextEvents(String fromTimestamp) {
        long timestamp = Long.parseLong(fromTimestamp);
        List<GwtEventInfo> result = this.getEvents(timestamp);
        if (!result.isEmpty()) {
            return result;
        }
        try {
            this.wait(30000L);
        }
        catch (InterruptedException interruptedException) {
            return new LinkedList<GwtEventInfo>();
        }
        return this.getEvents(timestamp);
    }

    @Override
    public synchronized String getLastEventTimestamp() {
        if (this.events.isEmpty()) {
            return "0";
        }
        return this.events.getFirst().getTimestamp();
    }

    public GwtEventInfo serialize(Event event) {
        GwtEventInfo result = new GwtEventInfo(event.getTopic());
        String[] stringArray = event.getPropertyNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            if (!"event".equals(property)) {
                Object obj = event.getProperty(property);
                result.set(property, obj != null ? obj.toString() : null);
            }
            ++n2;
        }
        return result;
    }
}

