/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.settings;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Widget;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.client.ui.EntryClassUi;
import org.eclipse.kura.web.client.ui.Tab;
import org.eclipse.kura.web.client.util.FailureHandler;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtSecurityService;
import org.eclipse.kura.web.shared.service.GwtSecurityServiceAsync;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenService;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenServiceAsync;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.AnchorButton;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.PanelCollapse;
import org.gwtbootstrap3.client.ui.html.Span;

public class SecurityTabUi
extends Composite
implements Tab {
    private static SecurityTabUiUiBinder uiBinder = (SecurityTabUiUiBinder)GWT.create(SecurityTabUiUiBinder.class);
    private static final Messages MSGS = (Messages)GWT.create(Messages.class);
    private final GwtSecurityTokenServiceAsync gwtXSRFService = (GwtSecurityTokenServiceAsync)GWT.create(GwtSecurityTokenService.class);
    private final GwtSecurityServiceAsync gwtSecurityService = (GwtSecurityServiceAsync)GWT.create(GwtSecurityService.class);
    @UiField
    HTMLPanel description;
    @UiField
    Anchor collapseOneAnchor;
    @UiField
    Anchor collapseTwoAnchor;
    @UiField
    PanelCollapse collapseOne;
    @UiField
    PanelCollapse collapseTwo;
    @UiField
    FormLabel securityPolicyLabel;
    @UiField
    FormLabel commandLineLabel;
    @UiField
    AnchorButton reloadPolicyFingerprint;
    @UiField
    AnchorButton reloadCommandLineFingerprint;

    public SecurityTabUi() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.initTab();
    }

    @Override
    public void setDirty(boolean flag) {
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void refresh() {
        if (this.isDirty()) {
            this.setDirty(false);
            this.reset();
        }
    }

    private void initTab() {
        StringBuilder title = new StringBuilder();
        title.append("<p>");
        title.append(MSGS.settingsSecurityDescription());
        title.append("</p>");
        this.description.add((Widget)new Span(title.toString()));
        this.collapseOneAnchor.setText(MSGS.settingsSecurityReloadPolicyTitle());
        this.collapseTwoAnchor.setText(MSGS.settingsReloadStartupFingerprintTitle());
        this.securityPolicyLabel.setText(MSGS.settingsSecurityReloadPolicyDescription());
        this.commandLineLabel.setText(MSGS.settingsReloadStartupFingerprintDescription());
        this.reloadPolicyFingerprint.setText(MSGS.settingsSecurityReloadPolicy());
        this.reloadPolicyFingerprint.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                EntryClassUi.showWaitModal();
                SecurityTabUi.this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

                    public void onFailure(Throwable ex) {
                        FailureHandler.handle(ex);
                        EntryClassUi.hideWaitModal();
                    }

                    public void onSuccess(GwtXSRFToken token) {
                        SecurityTabUi.this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

                            public void onFailure(Throwable ex) {
                                FailureHandler.handle(ex);
                                EntryClassUi.hideWaitModal();
                            }

                            public void onSuccess(GwtXSRFToken token) {
                                AsyncCallback<Void> callback = new AsyncCallback<Void>(){

                                    public void onFailure(Throwable caught) {
                                        FailureHandler.handle(caught);
                                        EntryClassUi.hideWaitModal();
                                    }

                                    public void onSuccess(Void result) {
                                        EntryClassUi.hideWaitModal();
                                    }
                                };
                                SecurityTabUi.this.gwtSecurityService.reloadSecurityPolicyFingerprint(token, callback);
                            }
                        });
                    }
                });
            }
        });
        this.reloadCommandLineFingerprint.setText(MSGS.settingsSecurityReloadPolicy());
        this.reloadCommandLineFingerprint.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                EntryClassUi.showWaitModal();
                SecurityTabUi.this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

                    public void onFailure(Throwable ex) {
                        FailureHandler.handle(ex);
                        EntryClassUi.hideWaitModal();
                    }

                    public void onSuccess(GwtXSRFToken token) {
                        SecurityTabUi.this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

                            public void onFailure(Throwable ex) {
                                FailureHandler.handle(ex);
                                EntryClassUi.hideWaitModal();
                            }

                            public void onSuccess(GwtXSRFToken token) {
                                AsyncCallback<Void> callback = new AsyncCallback<Void>(){

                                    public void onFailure(Throwable caught) {
                                        FailureHandler.handle(caught);
                                        EntryClassUi.hideWaitModal();
                                    }

                                    public void onSuccess(Void result) {
                                        EntryClassUi.hideWaitModal();
                                    }
                                };
                                SecurityTabUi.this.gwtSecurityService.reloadCommandLineFingerprint(token, callback);
                            }
                        });
                    }
                });
            }
        });
    }

    private void reset() {
    }

    static interface SecurityTabUiUiBinder
    extends UiBinder<Widget, SecurityTabUi> {
    }
}

