/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.internal.rpc.console;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.tigris.mtoolkit.iagent.internal.pmp.InvocationThread;
import org.tigris.mtoolkit.iagent.internal.rpc.Activator;
import org.tigris.mtoolkit.iagent.internal.utils.CircularBuffer;
import org.tigris.mtoolkit.iagent.pmp.EventListener;
import org.tigris.mtoolkit.iagent.pmp.PMPConnection;
import org.tigris.mtoolkit.iagent.pmp.PMPException;
import org.tigris.mtoolkit.iagent.pmp.RemoteMethod;
import org.tigris.mtoolkit.iagent.pmp.RemoteObject;
import org.tigris.mtoolkit.iagent.rpc.RemoteCapabilitiesManager;
import org.tigris.mtoolkit.iagent.rpc.RemoteConsole;

public abstract class RemoteConsoleServiceBase
implements RemoteConsole {
    private Map dispatchers = new HashMap();
    private ServiceRegistration registration;
    private PrintStream oldSystemOut;
    private PrintStream oldSystemErr;
    private PrintStream newSystemStream = new PrintStream(new RedirectedSystemOutput());
    private boolean replacedSystemOutputs = false;
    private EventListener closeConnectionHandler = new EventListener(){

        public void event(Object event, String evType) {
            if ("framework_disconnected_event".equals(evType)) {
                RemoteConsoleServiceBase.this.doReleaseConsole((PMPConnection)event);
            }
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void register(BundleContext context) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.tigris.mtoolkit.iagent.rpc.RemoteConsole");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registration = context.registerService(clazz.getName(), (Object)this, null);
        RemoteCapabilitiesManager capMan = Activator.getCapabilitiesManager();
        if (capMan != null) {
            capMan.setCapability("remote.console.support", new Boolean(true));
        }
    }

    public void unregister() {
        this.registration.unregister();
        this.restoreSystemOutputs();
        RemoteCapabilitiesManager capMan = Activator.getCapabilitiesManager();
        if (capMan != null) {
            capMan.setCapability("remote.console.support", new Boolean(false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutput(RemoteObject remoteObject) throws PMPException {
        PMPConnection conn = InvocationThread.getContext().getConnection();
        WriteDispatcher dispatcher = this.createDispatcher(conn, new CircularBuffer(), remoteObject);
        dispatcher.start();
        conn.addEventListener(this.closeConnectionHandler, new String[]{"framework_disconnected_event"});
        Map map = this.dispatchers;
        synchronized (map) {
            WriteDispatcher oldDispatcher = this.dispatchers.put(conn, dispatcher);
            if (oldDispatcher != null) {
                oldDispatcher.finish();
            }
            this.replaceSystemOutputs();
        }
    }

    protected WriteDispatcher createDispatcher(PMPConnection conn, CircularBuffer buffer, RemoteObject remoteObject) throws PMPException {
        return new WriteDispatcher(conn, buffer, remoteObject);
    }

    public synchronized void releaseConsole() {
        PMPConnection conn = InvocationThread.getContext().getConnection();
        this.doReleaseConsole(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReleaseConsole(PMPConnection conn) {
        Map map = this.dispatchers;
        synchronized (map) {
            WriteDispatcher dispatcher = (WriteDispatcher)this.dispatchers.remove(conn);
            if (dispatcher != null) {
                dispatcher.finish();
            }
            if (this.dispatchers.size() == 0) {
                this.restoreSystemOutputs();
            }
        }
    }

    protected void print(String msg) {
        byte[] msgBytes = msg.getBytes();
        this.print(msgBytes, 0, msgBytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void print(byte[] buf, int off, int len) {
        WriteDispatcher dispatcher;
        PMPConnection conn = InvocationThread.getContext().getConnection();
        Object object = this.dispatchers;
        synchronized (object) {
            dispatcher = (WriteDispatcher)this.dispatchers.get(conn);
            if (dispatcher == null) {
                return;
            }
        }
        dispatcher.buffer.write(buf, off, len);
        object = dispatcher;
        synchronized (object) {
            dispatcher.notifyAll();
        }
    }

    protected synchronized void replaceSystemOutputs() {
        if (this.replacedSystemOutputs) {
            return;
        }
        this.oldSystemOut = System.out;
        this.oldSystemErr = System.err;
        System.setOut(this.newSystemStream);
        System.setErr(this.newSystemStream);
        this.replacedSystemOutputs = true;
    }

    protected synchronized void restoreSystemOutputs() {
        if (this.replacedSystemOutputs) {
            if (System.out == this.newSystemStream) {
                System.setOut(this.oldSystemOut);
            }
            if (System.err == this.newSystemStream) {
                System.setErr(this.oldSystemErr);
            }
            this.replacedSystemOutputs = false;
        }
    }

    protected WriteDispatcher getDispatcher(PMPConnection conn) {
        return (WriteDispatcher)this.dispatchers.get(conn);
    }

    public abstract /* synthetic */ void executeCommand(String var1);

    private class RedirectedSystemOutput
    extends OutputStream {
        private byte[] singleByte = new byte[1];

        private RedirectedSystemOutput() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void write(byte[] var0, int var1, int var2) throws IOException {
            RemoteConsoleServiceBase.this.oldSystemOut.write(var0, var1, var2);
            Map map = RemoteConsoleServiceBase.this.dispatchers;
            synchronized (map) {
                Iterator it = RemoteConsoleServiceBase.this.dispatchers.values().iterator();
                while (it.hasNext()) {
                    WriteDispatcher dispatcher = (WriteDispatcher)it.next();
                    dispatcher.buffer.write(var0, var1, var2);
                    WriteDispatcher writeDispatcher = dispatcher;
                    synchronized (writeDispatcher) {
                        dispatcher.notifyAll();
                    }
                }
            }
        }

        public synchronized void write(byte[] var0) throws IOException {
            this.write(var0, 0, var0.length);
        }

        public synchronized void write(int arg0) throws IOException {
            this.singleByte[0] = (byte)(arg0 & 0xFF);
            this.write(this.singleByte, 0, 1);
        }

        public synchronized void flush() throws IOException {
            RemoteConsoleServiceBase.this.oldSystemOut.flush();
        }
    }

    protected class WriteDispatcher
    extends Thread {
        public PMPConnection conn;
        public CircularBuffer buffer;
        public RemoteMethod method;
        public RemoteObject object;
        private volatile boolean running = true;

        public WriteDispatcher(PMPConnection conn, CircularBuffer buffer, RemoteObject object) throws PMPException {
            super("Remote Console Dispatcher");
            this.conn = conn;
            this.buffer = buffer;
            this.object = object;
            String[] stringArray = new String[3];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[B");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            stringArray[0] = clazz.getName();
            stringArray[1] = Integer.TYPE.getName();
            stringArray[2] = Integer.TYPE.getName();
            this.method = object.getMethod("write", stringArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block9: while (true) {
                WriteDispatcher writeDispatcher = this;
                synchronized (writeDispatcher) {
                    while (this.buffer.available() <= 0 && this.running && this.conn.isConnected()) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (!this.running || !this.conn.isConnected()) {
                    try {
                        this.object.dispose();
                        return;
                    }
                    catch (PMPException pMPException) {}
                    return;
                }
                byte[] buf = new byte[1024];
                while (true) {
                    if (this.buffer.available() <= 0) continue block9;
                    int read = this.buffer.read(buf);
                    try {
                        this.method.invoke(new Object[]{buf, new Integer(0), new Integer(read)}, true);
                    }
                    catch (PMPException pMPException) {}
                }
                break;
            }
        }

        public synchronized void finish() {
            this.running = false;
            this.notifyAll();
        }
    }
}

