/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.internal.rpc.console;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.FrameworkCommandProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.tigris.mtoolkit.iagent.internal.rpc.console.EquinoxCommandInterpreter;
import org.tigris.mtoolkit.iagent.internal.rpc.console.RemoteConsoleServiceBase;
import org.tigris.mtoolkit.iagent.pmp.PMPException;
import org.tigris.mtoolkit.iagent.pmp.RemoteObject;
import org.tigris.mtoolkit.iagent.rpc.Remote;

public class EquinoxRemoteConsole
extends RemoteConsoleServiceBase
implements Remote {
    private ServiceTracker providersTrack;
    private BundleContext context;
    private FrameworkCommandProvider frameworkProvider;
    private boolean fwProviderInitializationTried = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public void register(BundleContext bundleContext) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.framework.internal.core.Framework");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        clazz.getName();
        this.context = bundleContext;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.osgi.framework.console.CommandProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.providersTrack = new ServiceTracker(bundleContext, clazz2.getName(), null);
        super.register(bundleContext);
    }

    public void unregister() {
        super.unregister();
        this.providersTrack.close();
    }

    public void registerOutput(RemoteObject remoteObject) throws PMPException {
        super.registerOutput(remoteObject);
        this.printPrompt();
    }

    public Class[] remoteInterfaces() {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.tigris.mtoolkit.iagent.rpc.RemoteConsole");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return classArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeCommand(String line) {
        try {
            block9: {
                block8: {
                    if (line == null) break block8;
                    if (line.trim().length() != 0) break block9;
                }
                Object var5_2 = null;
                this.printPrompt();
                return;
            }
            this.providersTrack.open();
            Object[] providers = this.getCommandProviders();
            EquinoxCommandInterpreter interpreter = new EquinoxCommandInterpreter(line, providers, this);
            String nextLine = interpreter.nextArgument();
            if (nextLine != null) {
                interpreter.execute(nextLine);
            }
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            this.printPrompt();
            throw throwable;
        }
        {
            Object var5_4 = null;
            this.printPrompt();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getCommandProviders() {
        Object[] providers;
        ServiceTracker serviceTracker = this.providersTrack;
        synchronized (serviceTracker) {
            block16: {
                providers = this.providersTrack.getServices();
                if (!this.fwProviderInitializationTried) {
                    this.fwProviderInitializationTried = true;
                    boolean frameworkProviderRegistered = false;
                    if (providers != null) {
                        int i = 0;
                        while (i < providers.length) {
                            if (providers[i] instanceof FrameworkCommandProvider) {
                                frameworkProviderRegistered = true;
                                break;
                            }
                            ++i;
                        }
                    }
                    if (!frameworkProviderRegistered) {
                        try {
                            Framework fw = this.getEquinoxFramework(this.context);
                            if (fw == null) break block16;
                            Class<?> clazz = class$3;
                            if (clazz == null) {
                                try {
                                    clazz = class$3 = Class.forName("org.eclipse.osgi.framework.internal.core.FrameworkCommandProvider");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            this.frameworkProvider = (FrameworkCommandProvider)this.invokeConstructor(clazz, fw);
                            if (this.frameworkProvider != null) {
                                try {
                                    EquinoxRemoteConsole.invokeMethod(this.frameworkProvider, "intialize");
                                }
                                catch (Exception exception) {
                                    EquinoxRemoteConsole.invokeMethod(this.frameworkProvider, "start");
                                }
                            }
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        return providers;
    }

    void printPrompt() {
        this.print(String.valueOf(System.getProperty("line.separator")) + "osgi> ");
    }

    private Framework getEquinoxFramework(BundleContext context) {
        Bundle bundle = context.getBundle();
        if (bundle instanceof AbstractBundle) {
            Framework framework = (Framework)this.getFieldValue(bundle, "framework");
            return framework;
        }
        return null;
    }

    private Object getFieldValue(Object obj, String fieldName) {
        Class<?> c = obj.getClass();
        Field f = null;
        try {
            f = c.getDeclaredField(fieldName);
            return f.get(obj);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            ((AccessibleObject)f).setAccessible(true);
            try {
                return f.get(obj);
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
                return null;
            }
        }
    }

    private Object invokeConstructor(Class clazz, Object parameter) throws Exception {
        try {
            Constructor c = clazz.getConstructor(parameter.getClass());
            return c.newInstance(parameter);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Exception) {
                throw (Exception)e.getTargetException();
            }
            e.getTargetException().printStackTrace();
            return null;
        }
    }

    private static Object invokeMethod(Object obj, String methodName) throws Exception {
        Method method = obj.getClass().getDeclaredMethod(methodName, null);
        ((AccessibleObject)method).setAccessible(true);
        return method.invoke(obj, null);
    }
}

