/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.internal.pmp;

import java.io.IOException;
import java.io.InputStream;
import org.tigris.mtoolkit.iagent.internal.pmp.PMPData;
import org.tigris.mtoolkit.iagent.internal.pmp.PMPSessionThread;

class PMPInputStream
extends InputStream {
    protected PMPSessionThread c;
    private short msgID = (short)-1;
    private byte[] buffer;
    private short position = 0;
    private InputStream is;
    private boolean more = false;
    private short messageL = 0;
    private short currentL = 0;
    protected int timeout;
    private boolean locked = false;
    private int waiting = 0;
    private static final String ERRMSG1 = "Protocol Error";
    private static final String ERRMSG2 = "Message ID Mismatch ";
    static int stream_timeout = 0;

    static {
        String stimeout = System.getProperty("iagent.pmp.stream_timeout");
        if (stimeout != null) {
            try {
                stream_timeout = Integer.parseInt(stimeout);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public PMPInputStream(InputStream is, PMPSessionThread c) {
        this.is = is;
        this.c = c;
        this.timeout = stream_timeout;
        this.buffer = new byte[4096];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short nextMessage() throws IOException {
        PMPInputStream pMPInputStream = this;
        synchronized (pMPInputStream) {
            while (this.locked) {
                ++this.waiting;
                try {
                    this.wait();
                }
                catch (Exception exception) {}
                --this.waiting;
            }
        }
        if (this.msgID != -1) {
            this.skipRest();
        }
        boolean ping = true;
        while (true) {
            try {
                this.msgID = PMPData.readShort(this.is);
            }
            catch (IOException ioExc) {
                if (ping) {
                    this.c.ping();
                    ping = false;
                    continue;
                }
                this.throwException(ioExc);
            }
            break;
        }
        this.readHeader();
        this.fillBuffer();
        return this.msgID;
    }

    public int read() throws IOException {
        if (this.position == this.currentL) {
            if (this.messageL > 0) {
                this.fillBuffer();
                return this.read();
            }
            if (this.more) {
                this.readNext();
                return this.read();
            }
            return -1;
        }
        short s = this.position;
        this.position = (short)(s + 1);
        return this.buffer[s] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.position == this.currentL) {
            if (this.messageL > 0) {
                this.fillBuffer();
            } else if (this.more) {
                this.readNext();
            } else {
                return -1;
            }
        }
        int more1 = len - (this.currentL - this.position);
        int read = 0;
        if (more1 <= 0) {
            System.arraycopy(this.buffer, this.position, b, off, len);
            this.position = (short)(this.position + len);
            read = len;
        } else {
            int first = len - more1;
            System.arraycopy(this.buffer, this.position, b, off, first);
            if (this.messageL > 0) {
                this.fillBuffer();
                read = first + this.read(b, off + first, len - first);
            } else if (this.more) {
                this.readNext();
                read = first + this.read(b, off + first, len - first);
            } else {
                this.position = (short)(this.position + first);
                read = first;
            }
        }
        return read;
    }

    public int available() throws IOException {
        int available = this.currentL - this.position + this.messageL;
        if (available == 0 && this.more) {
            this.readNext();
            return this.available();
        }
        this.c.debug("available " + available);
        return available;
    }

    private void readNext() throws IOException {
        this.checkNextMsgID();
        this.readHeader();
        this.fillBuffer();
    }

    public long skip(long toSkip) throws IOException {
        if (this.position == this.currentL) {
            if (this.messageL > 0) {
                this.fillBuffer();
            } else if (this.more) {
                this.readNext();
            } else {
                return 0L;
            }
        }
        long more1 = toSkip - (long)(this.currentL - this.position);
        long skipped = 0L;
        if (more1 <= 0L) {
            this.position = (short)(this.position + (int)toSkip);
            skipped = toSkip;
        } else {
            int first = (int)(toSkip - more1);
            if (this.messageL > 0) {
                this.fillBuffer();
                skipped = (long)first + this.skip(toSkip - (long)first);
            } else if (this.more) {
                this.readNext();
                skipped = (long)first + this.skip(toSkip - (long)first);
            } else {
                this.position = (short)(this.position + first);
                skipped = first;
            }
        }
        return skipped;
    }

    private void checkNextMsgID() throws IOException {
        short nextMsgID = -1;
        try {
            nextMsgID = PMPData.readShort(this.is);
        }
        catch (IOException ioExc) {
            this.throwException(ioExc);
        }
        if (nextMsgID != this.msgID) {
            this.throwException(new IOException(ERRMSG2));
        }
    }

    private void readHeader() throws IOException {
        int tmp = 0;
        try {
            this.messageL = PMPData.readShort(this.is);
            tmp = this.is.read();
            this.more = tmp == 0;
        }
        catch (IOException ioExc) {
            this.throwException(ioExc);
        }
        if (tmp == -1) {
            this.throwException(new IOException(ERRMSG1));
        }
    }

    private void fillBuffer() throws IOException {
        this.currentL = (short)(this.messageL > 4096 ? 4096 : (int)this.messageL);
        int read = 0;
        int tmp = 0;
        while (read < this.currentL) {
            try {
                tmp = this.is.read(this.buffer, read, this.currentL - read);
            }
            catch (IOException ioExc) {
                this.throwException(ioExc);
            }
            if (tmp == -1) {
                this.throwException(new IOException(ERRMSG1));
            }
            read += tmp;
        }
        this.messageL = (short)(this.messageL - this.currentL);
        this.position = 0;
    }

    private void skipRest() throws IOException {
        while (true) {
            if (this.messageL > 0) {
                try {
                    this.is.skip(this.messageL);
                }
                catch (IOException ioExc) {
                    this.throwException(ioExc);
                }
            }
            if (!this.more) break;
            this.checkNextMsgID();
            this.readHeader();
        }
    }

    protected void throwException(IOException ioExc) throws IOException {
        this.c.os.checkWaitStatus(ioExc.toString());
        throw ioExc;
    }

    protected synchronized void lock() {
        this.locked = true;
    }

    protected synchronized void unlock() {
        this.locked = false;
        if (this.waiting > 0) {
            this.notifyAll();
        }
    }

    public void close() throws IOException {
        this.is.close();
    }
}

