/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.deployment;

import java.util.Objects;
import java.util.Properties;
import org.osgi.service.component.ComponentException;

public class CloudDeploymentHandlerOptions {
    private static final String DPA_CONF_PATH_PROPNAME = "dpa.configuration";
    private static final String PACKAGES_PATH_PROPNAME = "kura.packages";
    private static final String KURA_DATA_DIR = "kura.data";
    private final Properties properties;

    public CloudDeploymentHandlerOptions(Properties properties) {
        Objects.requireNonNull(properties, "Properties cannot be null");
        this.properties = properties;
    }

    public String getDpaConfigurationFilePath() {
        String dpaPath = System.getProperty(DPA_CONF_PATH_PROPNAME);
        if (dpaPath == null || dpaPath.isEmpty()) {
            throw new ComponentException("The value of 'dpa.configuration' is not defined");
        }
        return dpaPath;
    }

    public String getPackagesPath() {
        String packagesPath = this.properties.getProperty(PACKAGES_PATH_PROPNAME);
        if (packagesPath == null || packagesPath.isEmpty()) {
            throw new ComponentException("The value of 'kura.packages' is not defined");
        }
        return packagesPath;
    }

    public String getKuraDataDir() {
        String kuraDataDir = this.properties.getProperty(KURA_DATA_DIR);
        if (kuraDataDir == null || kuraDataDir.isEmpty()) {
            throw new ComponentException("The value of 'kura.data' is not defined");
        }
        return kuraDataDir;
    }
}

