/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.driver;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.kura.driver.Driver;
import org.eclipse.kura.driver.descriptor.DriverDescriptor;
import org.eclipse.kura.driver.descriptor.DriverDescriptorService;
import org.eclipse.kura.util.service.ServiceUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverDescriptorServiceImpl
implements DriverDescriptorService {
    private static final Logger logger = LoggerFactory.getLogger(DriverDescriptorServiceImpl.class);
    private BundleContext bundleContext;

    public void activate(ComponentContext componentContext) {
        this.bundleContext = componentContext.getBundleContext();
    }

    public Optional<DriverDescriptor> getDriverDescriptor(String driverPid) {
        Objects.requireNonNull(driverPid, "Driver PID cannot be null");
        DriverDescriptor driverDescriptor = null;
        String filterString = String.format("(&(kura.service.pid=%s))", driverPid);
        ServiceReference<Driver>[] refs = this.getDriverServiceReferences(filterString);
        try {
            ServiceReference<Driver>[] serviceReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference<Driver> driverServiceReference = serviceReferenceArray[n2];
                String factoryPid = driverServiceReference.getProperty("service.factoryPid").toString();
                Driver driver = (Driver)this.bundleContext.getService(driverServiceReference);
                driverDescriptor = this.newDriverDescriptor(driverPid, factoryPid, driver);
                ++n2;
            }
        }
        finally {
            this.ungetDriverServiceReferences(refs);
        }
        return Optional.ofNullable(driverDescriptor);
    }

    public List<DriverDescriptor> listDriverDescriptors() {
        ArrayList<DriverDescriptor> driverDescriptors = new ArrayList<DriverDescriptor>();
        ServiceReference<Driver>[] refs = this.getDriverServiceReferences(null);
        try {
            ServiceReference<Driver>[] serviceReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference<Driver> driverServiceReference = serviceReferenceArray[n2];
                String driverPid = driverServiceReference.getProperty("kura.service.pid").toString();
                String factoryPid = driverServiceReference.getProperty("service.factoryPid").toString();
                Driver driver = (Driver)this.bundleContext.getService(driverServiceReference);
                driverDescriptors.add(this.newDriverDescriptor(driverPid, factoryPid, driver));
                ++n2;
            }
        }
        finally {
            this.ungetDriverServiceReferences(refs);
        }
        return driverDescriptors;
    }

    private DriverDescriptor newDriverDescriptor(String driverPid, String factoryPid, Driver driver) {
        Object channelDescriptorObj = null;
        try {
            channelDescriptorObj = driver.getChannelDescriptor().getDescriptor();
        }
        catch (Exception e) {
            logger.warn("Failed to get driver descriptor for pid: {}", (Object)driverPid, (Object)e);
        }
        return new DriverDescriptor(driverPid, factoryPid, channelDescriptorObj);
    }

    protected ServiceReference<Driver>[] getDriverServiceReferences(String filter) {
        return ServiceUtil.getServiceReferences((BundleContext)this.bundleContext, Driver.class, (String)filter);
    }

    protected void ungetDriverServiceReferences(ServiceReference<Driver>[] refs) {
        ServiceUtil.ungetServiceReferences((BundleContext)this.bundleContext, refs);
    }
}

