/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.emulator.clock;

import java.util.Date;
import java.util.Map;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.clock.ClockService;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClockServiceImpl
implements ConfigurableComponent,
ClockService {
    private static final Logger s_logger = LoggerFactory.getLogger(ClockServiceImpl.class);
    private ComponentContext m_ctx;
    private EventAdmin m_eventAdmin;
    private Map<String, Object> m_properties;

    public void setEventAdmin(EventAdmin eventAdmin) {
        this.m_eventAdmin = eventAdmin;
    }

    public void unsetEventAdmin(EventAdmin eventAdmin) {
        this.m_eventAdmin = null;
    }

    protected void activate(ComponentContext componentContext) {
        s_logger.info("Activate. Current Time: {}", (Object)new Date());
        this.m_ctx = componentContext;
    }

    protected void deactivate(ComponentContext componentContext) {
        s_logger.info("Deactivate...");
    }

    public void updated(Map<String, Object> properties) {
        s_logger.info("Updated...");
        try {
            this.m_properties = properties;
        }
        catch (Throwable t) {
            s_logger.error("Error updating ClockService Configuration", t);
        }
    }

    public Date getLastSync() throws KuraException {
        return new Date();
    }
}

