/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.internal.data;

public class TokenBucket {
    private final int capacity;
    private final long refillPeriod;
    private int remainingTokens;
    private long lastRefillTime;

    public TokenBucket(int capacity, long refillPeriod) {
        this.capacity = capacity;
        this.remainingTokens = capacity;
        this.refillPeriod = refillPeriod;
        this.lastRefillTime = System.nanoTime();
    }

    public boolean getToken() {
        boolean result = false;
        this.refill();
        if (this.isTokenAvailable()) {
            --this.remainingTokens;
            result = true;
        }
        return result;
    }

    private boolean isTokenAvailable() {
        return this.remainingTokens != 0;
    }

    private void refill() {
        long now = System.nanoTime();
        if (now - this.lastRefillTime >= this.refillPeriod) {
            this.remainingTokens = (int)Math.min((long)this.capacity, (long)this.remainingTokens + (now - this.lastRefillTime) / this.refillPeriod);
            this.remainingTokens = Math.max(1, this.remainingTokens);
            this.lastRefillTime += (now - this.lastRefillTime) / this.refillPeriod * this.refillPeriod;
        }
    }

    public long getTokenWaitTime() {
        long now = System.nanoTime();
        long timeToRefill = this.lastRefillTime + this.refillPeriod - now;
        return Math.max(0L, timeToRefill);
    }
}

