/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.db;

import java.util.Map;
import org.eclipse.kura.core.db.H2DbServer;

class H2DbServerOptions {
    private static final String DB_SERVER_ENABLED_PROP_NAME = "db.server.enabled";
    private static final String DB_SERVER_TYPE_PROP_NAME = "db.server.type";
    private static final String DB_COMMAND_LINE_PROP_NAME = "db.server.commandline";
    private static final Boolean DB_SERVER_ENABLED_DEFAULT = false;
    private static final String DB_SERVER_COMMAND_LINE_DEFAULT = "-tcpPort 9123 -tcpAllowOthers -ifExists";
    private final Boolean isServerEnabled;
    private final H2DbServer.ServerType serverType;
    private final String serverCommandLine;

    private <T> T getSafe(Object o, T defaultValue) {
        if (defaultValue.getClass().isInstance(o)) {
            return (T)o;
        }
        return defaultValue;
    }

    public H2DbServerOptions(Map<String, Object> properties) {
        this.isServerEnabled = this.getSafe(properties.get(DB_SERVER_ENABLED_PROP_NAME), DB_SERVER_ENABLED_DEFAULT);
        this.serverCommandLine = this.getSafe(properties.get(DB_COMMAND_LINE_PROP_NAME), DB_SERVER_COMMAND_LINE_DEFAULT);
        String serverTypeString = (String)properties.getOrDefault(DB_SERVER_TYPE_PROP_NAME, "TCP");
        this.serverType = H2DbServer.ServerType.WEB.name().equals(serverTypeString) ? H2DbServer.ServerType.WEB : (H2DbServer.ServerType.PG.name().equals(serverTypeString) ? H2DbServer.ServerType.PG : H2DbServer.ServerType.TCP);
    }

    public Boolean isServerEnabled() {
        return this.isServerEnabled;
    }

    public H2DbServer.ServerType getServerType() {
        return this.serverType;
    }

    public String getServerCommandLine() {
        return this.serverCommandLine;
    }
}

