/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.camel.component;

import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.eclipse.kura.camel.component.AbstractCamelComponent;
import org.eclipse.kura.camel.runner.CamelRunner;
import org.eclipse.kura.camel.runner.ContextFactory;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJavaCamelComponent
extends RouteBuilder
implements ConfigurableComponent {
    private static final String PROP_DISABLE_JMX = "org.eclipse.kura.camel.component.disableJmx";
    private static final Logger logger = LoggerFactory.getLogger(AbstractJavaCamelComponent.class);
    protected CamelRunner runner;

    protected void start() throws Exception {
        logger.info("Starting camel router");
        CamelRunner.Builder builder = new CamelRunner.Builder();
        builder.contextFactory(this.getContextFactory());
        builder.disableJmx(Boolean.getBoolean(PROP_DISABLE_JMX));
        builder.addBeforeStart(camelContext -> {
            this.beforeStart(camelContext);
            camelContext.addRoutes((RoutesBuilder)this);
        });
        this.runner = builder.build();
        this.runner.start();
    }

    protected void stop() throws Exception {
        logger.info("Stopping camel router");
        if (this.runner != null) {
            this.runner.stop();
            this.runner = null;
        }
    }

    protected void beforeStart(CamelContext camelContext) {
    }

    protected ContextFactory getContextFactory() {
        return CamelRunner.createOsgiFactory(this.getBundleContext());
    }

    protected BundleContext getBundleContext() {
        return FrameworkUtil.getBundle(AbstractCamelComponent.class).getBundleContext();
    }
}

