/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.configuration.ComponentConfiguration;
import org.eclipse.kura.configuration.ConfigurationService;
import org.eclipse.kura.core.configuration.XmlComponentConfigurations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UpdateConfigurationsCallable
implements Callable<Void> {
    private static Logger logger = LoggerFactory.getLogger(UpdateConfigurationsCallable.class);
    private final String pid;
    private final XmlComponentConfigurations xmlConfigurations;
    private final ConfigurationService configurationService;

    public UpdateConfigurationsCallable(String pid, XmlComponentConfigurations xmlConfigurations, ConfigurationService configurationService) {
        this.pid = pid;
        this.xmlConfigurations = xmlConfigurations;
        this.configurationService = configurationService;
    }

    @Override
    public Void call() throws Exception {
        List<ComponentConfiguration> configImpls;
        block6: {
            logger.info("Updating configurations");
            Thread.currentThread().setName(this.getClass().getSimpleName());
            List<ComponentConfiguration> list = configImpls = this.xmlConfigurations != null ? this.xmlConfigurations.getConfigurations() : null;
            if (configImpls != null) break block6;
            return null;
        }
        try {
            ArrayList<ComponentConfiguration> configs = new ArrayList<ComponentConfiguration>();
            configs.addAll(configImpls);
            if (this.pid == null) {
                this.configurationService.updateConfigurations(configs);
            } else {
                for (ComponentConfiguration config : configs) {
                    if (!this.pid.equals(config.getPid())) continue;
                    this.configurationService.updateConfiguration(this.pid, config.getConfigurationProperties());
                }
            }
        }
        catch (KuraException e) {
            logger.error("Error updating configurations: {}", (Throwable)e);
            throw new KuraException(KuraErrorCode.CONFIGURATION_UPDATE, (Throwable)e, new Object[0]);
        }
        return null;
    }
}

