/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.component.xslt.XsltComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class XsltHelper {
    private static final Logger LOG = LoggerFactory.getLogger(XsltHelper.class);
    private static final String SAXON_CONFIGURATION_CLASS_NAME = "net.sf.saxon.Configuration";
    private static final String SAXON_EXTENDED_FUNCTION_DEFINITION_CLASS_NAME = "net.sf.saxon.lib.ExtensionFunctionDefinition";

    private XsltHelper() {
    }

    public static void registerSaxonConfiguration(CamelContext camelContext, Class<?> factoryClass, TransformerFactory factory, Object saxonConfiguration) throws Exception {
        Method method;
        Class<?> configurationClass;
        if (saxonConfiguration != null && (configurationClass = camelContext.getClassResolver().resolveClass(SAXON_CONFIGURATION_CLASS_NAME)) != null && (method = factoryClass.getMethod("setConfiguration", configurationClass)) != null) {
            method.invoke((Object)factory, configurationClass.cast(saxonConfiguration));
        }
    }

    public static void registerSaxonConfigurationProperties(CamelContext camelContext, Class<?> factoryClass, TransformerFactory factory, Map<String, Object> saxonConfigurationProperties) throws Exception {
        Object configuration;
        Method method;
        if (saxonConfigurationProperties != null && !saxonConfigurationProperties.isEmpty() && (method = factoryClass.getMethod("getConfiguration", new Class[0])) != null && (configuration = method.invoke((Object)factory, null)) != null) {
            method = configuration.getClass().getMethod("setConfigurationProperty", String.class, Object.class);
            for (Map.Entry<String, Object> entry : saxonConfigurationProperties.entrySet()) {
                method.invoke(configuration, entry.getKey(), entry.getValue());
            }
        }
    }

    public static void registerSaxonExtensionFunctions(CamelContext camelContext, Class<?> factoryClass, TransformerFactory factory, List<Object> saxonExtensionFunctions) throws Exception {
        if (saxonExtensionFunctions != null && !saxonExtensionFunctions.isEmpty()) {
            Method method = factoryClass.getMethod("getConfiguration", new Class[0]);
            if (method != null) {
                Object configuration = method.invoke((Object)factory, null);
                if (configuration != null) {
                    Class<?> extensionClass = camelContext.getClassResolver().resolveMandatoryClass(SAXON_EXTENDED_FUNCTION_DEFINITION_CLASS_NAME, XsltComponent.class.getClassLoader());
                    method = configuration.getClass().getMethod("registerExtensionFunction", extensionClass);
                    if (method != null) {
                        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                        for (Object extensionFunction : saxonExtensionFunctions) {
                            if (!extensionClass.isInstance(extensionFunction)) continue;
                            LOG.debug("Saxon.registerExtensionFunction {}", extensionFunction);
                            method.invoke(configuration, extensionFunction);
                        }
                    } else {
                        LOG.warn("Unable to get reference to method registerExtensionFunction on {}", (Object)configuration.getClass().getName());
                    }
                } else {
                    LOG.warn("Unable to get Saxon configuration ({}) on {}", (Object)SAXON_CONFIGURATION_CLASS_NAME, (Object)factory.getClass().getName());
                }
            } else {
                LOG.warn("Unable to get reference to method getConfiguration on {}", (Object)factoryClass.getName());
            }
        }
    }
}

