/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.ble.beacon;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.eclipse.kura.KuraBluetoothBeaconAdvertiserNotAvailable;
import org.eclipse.kura.KuraBluetoothCommandException;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.bluetooth.le.BluetoothLeAdapter;
import org.eclipse.kura.bluetooth.le.beacon.AdvertisingReportRecord;
import org.eclipse.kura.bluetooth.le.beacon.BluetoothLeBeacon;
import org.eclipse.kura.bluetooth.le.beacon.BluetoothLeBeaconAdvertiser;
import org.eclipse.kura.bluetooth.le.beacon.BluetoothLeBeaconDecoder;
import org.eclipse.kura.bluetooth.le.beacon.BluetoothLeBeaconEncoder;
import org.eclipse.kura.bluetooth.le.beacon.BluetoothLeBeaconManager;
import org.eclipse.kura.bluetooth.le.beacon.BluetoothLeBeaconScanner;
import org.eclipse.kura.bluetooth.le.beacon.listener.BluetoothLeBeaconListener;
import org.eclipse.kura.internal.ble.beacon.BluetoothLeBeaconAdvertiserImpl;
import org.eclipse.kura.internal.ble.beacon.BluetoothLeBeaconScannerImpl;
import org.eclipse.kura.internal.ble.util.BTSnoopListener;
import org.eclipse.kura.internal.ble.util.BluetoothLeUtil;
import org.eclipse.kura.internal.ble.util.BluetoothProcess;
import org.eclipse.kura.internal.ble.util.BluetoothProcessListener;
import org.osgi.service.component.ComponentContext;

public class BluetoothLeBeaconManagerImpl
implements BluetoothLeBeaconManager<BluetoothLeBeacon>,
BTSnoopListener,
BluetoothProcessListener {
    private static final String SET_ADVERTISING_PARAMETERS_HCITOOL_MESSAGE = "Set Advertising Parameters : hcitool -i {} {}";
    private static final Logger logger = LogManager.getLogger(BluetoothLeBeaconManagerImpl.class);
    private static final String OGF_CONTROLLER_CMD = "0x08";
    private static final String OCF_ADVERTISING_PARAM_CMD = "0x0006";
    private static final String OCF_ADVERTISING_DATA_CMD = "0x0008";
    private static final String OCF_ADVERTISING_ENABLE_CMD = "0x000a";
    private static final String CMD = "cmd";
    private static final String TWO_CHAR_REGEX = "(?<=\\G..)";
    private static Map<String, BluetoothLeBeaconAdvertiserImpl<BluetoothLeBeacon>> advertisers = new HashMap<String, BluetoothLeBeaconAdvertiserImpl<BluetoothLeBeacon>>();
    private static Map<String, List<BluetoothLeBeaconScannerImpl<BluetoothLeBeacon>>> scanners = new HashMap<String, List<BluetoothLeBeaconScannerImpl<BluetoothLeBeacon>>>();
    private BluetoothProcess dumpProc;
    private BluetoothProcess hcitoolProc;
    private Map<BluetoothLeBeaconListener<BluetoothLeBeacon>, Class<?>> listeners;

    protected void activate(ComponentContext context) {
        logger.info("Activating Bluetooth Le Beacon Manager...");
        this.listeners = new HashMap();
    }

    protected void deactivate(ComponentContext context) {
        logger.debug("Deactivating Bluetooth Le Beacon Manager...");
    }

    protected BluetoothProcess execBtdump(String interfaceName) throws IOException {
        return BluetoothLeUtil.btdumpCmd(interfaceName, this);
    }

    protected BluetoothProcess execHcitool(String interfaceName, String ... cmd) throws IOException {
        return BluetoothLeUtil.hcitoolCmd(interfaceName, cmd, (BluetoothProcessListener)this);
    }

    public BluetoothLeBeaconScanner<BluetoothLeBeacon> newBeaconScanner(BluetoothLeAdapter adapter, BluetoothLeBeaconDecoder<BluetoothLeBeacon> decoder) {
        BluetoothLeBeaconScannerImpl<BluetoothLeBeacon> scanner = new BluetoothLeBeaconScannerImpl<BluetoothLeBeacon>(adapter, decoder, this);
        if (scanners.containsKey(adapter.getInterfaceName())) {
            scanners.get(adapter.getInterfaceName()).add(scanner);
        } else {
            ArrayList<BluetoothLeBeaconScannerImpl<BluetoothLeBeacon>> scannerList = new ArrayList<BluetoothLeBeaconScannerImpl<BluetoothLeBeacon>>();
            scannerList.add(scanner);
            scanners.put(adapter.getInterfaceName(), scannerList);
        }
        return scanner;
    }

    public BluetoothLeBeaconAdvertiser<BluetoothLeBeacon> newBeaconAdvertiser(BluetoothLeAdapter adapter, BluetoothLeBeaconEncoder<BluetoothLeBeacon> encoder) throws KuraBluetoothBeaconAdvertiserNotAvailable {
        if (advertisers.containsKey(adapter.getInterfaceName())) {
            throw new KuraBluetoothBeaconAdvertiserNotAvailable((Object)("The Beacon Advertiser for " + adapter.getInterfaceName() + " has been already instanciated"));
        }
        BluetoothLeBeaconAdvertiserImpl<BluetoothLeBeacon> advertiser = new BluetoothLeBeaconAdvertiserImpl<BluetoothLeBeacon>(adapter, encoder, this);
        advertisers.put(adapter.getInterfaceName(), advertiser);
        return advertiser;
    }

    public void deleteBeaconScanner(BluetoothLeBeaconScanner<BluetoothLeBeacon> scanner) {
        String interfaceName = scanner.getAdapter().getInterfaceName();
        if (scanners.containsKey(interfaceName)) {
            scanners.get(interfaceName).remove(scanner);
        }
    }

    public void deleteBeaconAdvertiser(BluetoothLeBeaconAdvertiser<BluetoothLeBeacon> advertiser) {
        advertisers.remove(advertiser.getAdapter().getInterfaceName());
    }

    public void startBeaconAdvertising(String interfaceName) throws KuraBluetoothCommandException {
        String[] cmd = new String[]{CMD, OGF_CONTROLLER_CMD, OCF_ADVERTISING_ENABLE_CMD, "01"};
        logger.debug(SET_ADVERTISING_PARAMETERS_HCITOOL_MESSAGE, new Supplier[]{() -> interfaceName, () -> String.join((CharSequence)" ", cmd)});
        logger.info("Start Advertising on interface {}", (Object)interfaceName);
        try {
            this.execHcitool(interfaceName, cmd);
        }
        catch (IOException e) {
            throw new KuraBluetoothCommandException((Throwable)e, (Object)"Start bluetooth beacon advertising failed");
        }
    }

    public void stopBeaconAdvertising(String interfaceName) throws KuraBluetoothCommandException {
        String[] cmd = new String[]{CMD, OGF_CONTROLLER_CMD, OCF_ADVERTISING_ENABLE_CMD, "00"};
        logger.debug(SET_ADVERTISING_PARAMETERS_HCITOOL_MESSAGE, new Supplier[]{() -> interfaceName, () -> String.join((CharSequence)" ", cmd)});
        logger.info("Stop Advertising on interface {}", (Object)interfaceName);
        try {
            this.execHcitool(interfaceName, cmd);
        }
        catch (IOException e) {
            throw new KuraBluetoothCommandException((Throwable)e, (Object)"Stop bluetooth beacon advertising failed");
        }
    }

    public void updateBeaconAdvertisingInterval(Integer min, Integer max, String interfaceName) throws KuraBluetoothCommandException {
        this.checkInterval(min, max);
        String[] minHex = String.format("%04X", min).split(TWO_CHAR_REGEX);
        String[] maxHex = String.format("%04X", max).split(TWO_CHAR_REGEX);
        String[] cmd = new String[]{CMD, OGF_CONTROLLER_CMD, OCF_ADVERTISING_PARAM_CMD, minHex[1], minHex[0], maxHex[1], maxHex[0], "03", "00", "00", "00", "00", "00", "00", "00", "00", "07", "00"};
        logger.debug(SET_ADVERTISING_PARAMETERS_HCITOOL_MESSAGE, new Supplier[]{() -> interfaceName, () -> String.join((CharSequence)" ", cmd)});
        logger.info("Set Advertising Parameters on interface {}", (Object)interfaceName);
        try {
            this.execHcitool(interfaceName, cmd);
        }
        catch (IOException e) {
            throw new KuraBluetoothCommandException((Throwable)e, (Object)"Update bluetooth beacon advertising interval failed");
        }
    }

    private void checkInterval(Integer min, Integer max) {
        if (min > max) {
            throw new IllegalArgumentException("The minimum interval cannot be greater than the maximum.");
        }
        if (min < 14 || min > 65534) {
            throw new IllegalArgumentException("The minimum interval value must be between 14 and 65534.");
        }
        if (max < 14 || max > 65534) {
            throw new IllegalArgumentException("The maximum interval value must be between 14 and 65534.");
        }
    }

    public void updateBeaconAdvertisingData(BluetoothLeBeacon beacon, BluetoothLeBeaconEncoder<BluetoothLeBeacon> encoder, String interfaceName) throws KuraBluetoothCommandException {
        String[] data = BluetoothLeBeaconManagerImpl.toHexStringArray(encoder.encode(beacon));
        String[] cmd = new String[3 + data.length];
        cmd[0] = CMD;
        cmd[1] = OGF_CONTROLLER_CMD;
        cmd[2] = OCF_ADVERTISING_DATA_CMD;
        int i = 0;
        while (i < data.length) {
            cmd[i + 3] = data[i];
            ++i;
        }
        logger.debug("Set Advertising Data : hcitool -i {} {}", new Supplier[]{() -> interfaceName, () -> String.join((CharSequence)" ", cmd)});
        logger.info("Set Advertising Data on interface {}", (Object)interfaceName);
        try {
            this.execHcitool(interfaceName, cmd);
        }
        catch (IOException e) {
            throw new KuraBluetoothCommandException((Throwable)e, (Object)"Update bluetooth beacon advertising data failed");
        }
    }

    @Override
    public void processInputStream(String string) throws KuraException {
        logger.debug("Command response : {}", (Object)string);
        String[] lines = string.split("\n");
        if (!string.isEmpty() && lines.length >= 1) {
            if (lines[0].toLowerCase().contains("unknown") || lines.length >= 2 && lines[1].toLowerCase().contains("usage")) {
                throw new KuraBluetoothCommandException((Object)"Command failed. Error in command syntax.");
            }
            if (lines[0].toLowerCase().contains("invalid") || lines[0].toLowerCase().contains("error")) {
                throw new KuraBluetoothCommandException((Object)"Command failed.");
            }
            this.parseReturnString(lines);
        }
    }

    private void parseReturnString(String[] lines) throws KuraBluetoothCommandException {
        String lastLine = lines[lines.length - 1];
        String command = lines[0].substring(15, 35);
        String exitCode = lastLine.substring(11, 13);
        switch (exitCode.toLowerCase()) {
            case "00": {
                logger.debug("Command {} Succeeded.", (Object)command);
                break;
            }
            case "01": {
                logger.debug("Command {} failed. Error: Unknown HCI Command (01)", (Object)command);
                throw new KuraBluetoothCommandException((Object)("Command " + command + " failed. Error: Unknown HCI Command (01)"));
            }
            case "03": {
                logger.debug("Command {} failed. Error: Hardware Failure (03)", (Object)command);
                throw new KuraBluetoothCommandException((Object)("Command " + command + " failed. Error: Hardware Failure (03)"));
            }
            case "0c": {
                logger.debug("Command {} failed. Error: Command Disallowed (0C)", (Object)command);
                break;
            }
            case "11": {
                logger.debug("Command {} failed. Error: Unsupported Feature or Parameter Value (11)", (Object)command);
                throw new KuraBluetoothCommandException((Object)("Command " + command + " failed. Unsupported Feature or Parameter Value (11)"));
            }
            case "12": {
                logger.debug("Command {} failed. Error: Invalid HCI Command Parameters (12)", (Object)command);
                throw new KuraBluetoothCommandException((Object)("Command " + command + " failed. Error: Invalid HCI Command Parameters (12)"));
            }
            default: {
                logger.debug("Command {} failed. Error {}", (Object)command, (Object)exitCode);
                throw new KuraBluetoothCommandException((Object)("Command " + command + " failed. Error " + exitCode));
            }
        }
    }

    @Override
    public void processInputStream(int ch) throws KuraException {
    }

    @Override
    public void processErrorStream(String string) throws KuraException {
    }

    public static String[] toHexStringArray(byte[] in) {
        String[] out = new String[in.length];
        int i = 0;
        while (i < in.length) {
            out[i] = String.format("%02X", in[i]);
            ++i;
        }
        return out;
    }

    public void startBeaconScan(String interfaceName) throws KuraBluetoothCommandException {
        if (this.checkStartScanCondition(interfaceName)) {
            logger.info("Starting bluetooth beacon scan on {}", (Object)interfaceName);
            try {
                this.hcitoolProc = this.execHcitool(interfaceName, "lescan-passive", "--duplicates");
                this.dumpProc = this.execBtdump(interfaceName);
            }
            catch (IOException e) {
                throw new KuraBluetoothCommandException((Throwable)e, (Object)"Start bluetooth beacon scan failed");
            }
        }
    }

    public void stopBeaconScan(String interfaceName) {
        if (this.checkStopScanCondition(interfaceName)) {
            logger.info("Stopping bluetooth beacon scan on {}", (Object)interfaceName);
            if (this.hcitoolProc != null) {
                this.hcitoolProc.destroy();
            }
            if (this.dumpProc != null) {
                this.dumpProc.destroyBTSnoop();
            }
        }
    }

    public boolean checkStopScanCondition(String interfaceName) {
        boolean stopScan = false;
        if (!scanners.containsKey(interfaceName)) {
            stopScan = false;
        } else if (scanners.get(interfaceName).stream().mapToInt(e -> e.isScanning() ? 1 : 0).sum() == 1) {
            stopScan = true;
        }
        return stopScan;
    }

    public boolean checkStartScanCondition(String interfaceName) {
        boolean startScan = false;
        if (!scanners.containsKey(interfaceName)) {
            startScan = false;
        } else if (scanners.get(interfaceName).stream().mapToInt(e -> e.isScanning() ? 1 : 0).sum() == 0) {
            startScan = true;
        }
        return startScan;
    }

    public void addBeaconListener(BluetoothLeBeaconListener<BluetoothLeBeacon> listener, Class<?> clazz) {
        if (!this.listeners.containsKey(listener)) {
            this.listeners.put(listener, clazz);
        } else {
            logger.warn("The listener has been already registered");
        }
    }

    public void removeBeaconListener(BluetoothLeBeaconListener<BluetoothLeBeacon> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void processBTSnoopRecord(byte[] record) {
        List<AdvertisingReportRecord> reportRecords = BluetoothLeUtil.parseLEAdvertisement(record);
        if (!reportRecords.isEmpty()) {
            List decoders = scanners.values().stream().flatMap(Collection::stream).filter(scanner -> scanner.isScanning()).map(scanner -> scanner.getDecoder()).distinct().collect(Collectors.toList());
            ArrayList<BluetoothLeBeacon> beacons = new ArrayList<BluetoothLeBeacon>();
            for (AdvertisingReportRecord advertisingReportRecord : reportRecords) {
                for (BluetoothLeBeaconDecoder decoder : decoders) {
                    BluetoothLeBeacon beacon2 = decoder.decode(advertisingReportRecord.getReportData());
                    if (beacon2 == null) continue;
                    beacon2.setAddress(advertisingReportRecord.getAddress());
                    beacon2.setRssi(advertisingReportRecord.getRssi());
                    beacons.add(beacon2);
                }
            }
            if (!beacons.isEmpty() && !this.listeners.isEmpty()) {
                for (Map.Entry entry : this.listeners.entrySet()) {
                    beacons.stream().filter(beacon -> entry.getValue() == beacon.getClass()).collect(Collectors.toList()).forEach(arg_0 -> ((BluetoothLeBeaconListener)((BluetoothLeBeaconListener)entry.getKey())).onBeaconsReceived(arg_0));
                }
            }
        }
    }

    @Override
    public void processBTSnoopErrorStream(String string) {
    }
}

