/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import java.util.HashSet;
import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.ResourceInfoImpl;
import org.apache.felix.deploymentadmin.spi.Command;
import org.apache.felix.deploymentadmin.spi.CommitResourceCommand;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.deploymentadmin.DeploymentException;
import org.osgi.service.deploymentadmin.spi.ResourceProcessor;
import org.osgi.service.deploymentadmin.spi.ResourceProcessorException;
import org.osgi.service.log.LogService;

public class DropAllResourcesCommand
extends Command {
    private final CommitResourceCommand m_commitCommand;

    public DropAllResourcesCommand(CommitResourceCommand commitCommand) {
        this.m_commitCommand = commitCommand;
    }

    public void execute(DeploymentSessionImpl session) throws DeploymentException {
        this.addRollback(new RollbackCommitAction(session));
        AbstractDeploymentPackage target = session.getTargetAbstractDeploymentPackage();
        BundleContext context = session.getBundleContext();
        LogService log = session.getLog();
        HashSet<String> resourceProcessors = new HashSet<String>();
        ResourceInfoImpl[] orderedTargetResources = target.getOrderedResourceInfos();
        for (int i = orderedTargetResources.length - 1; i >= 0; --i) {
            ResourceInfoImpl resourceInfo = orderedTargetResources[i];
            String rpName = resourceInfo.getResourceProcessor();
            String path = resourceInfo.getPath();
            if (resourceProcessors.contains(rpName)) continue;
            resourceProcessors.add(rpName);
            ServiceReference ref = target.getResourceProcessor(path);
            if (ref == null) {
                log.log(1, "Failed to find resource processor for '" + rpName + "'!");
                throw new DeploymentException(464, "Failed to find resource processor '" + rpName + "'!");
            }
            ResourceProcessor resourceProcessor = (ResourceProcessor)context.getService(ref);
            if (resourceProcessor == null) {
                log.log(1, "Failed to find resource processor for '" + rpName + "'!");
                throw new DeploymentException(464, "Failed to find resource processor '" + rpName + "'!");
            }
            try {
                if (this.m_commitCommand.addResourceProcessor(resourceProcessor)) {
                    resourceProcessor.begin(session);
                }
                resourceProcessor.dropAllResources();
                continue;
            }
            catch (ResourceProcessorException e) {
                log.log(1, "Failed to drop all resources for resource processor '" + rpName + "'!", (Throwable)e);
                throw new DeploymentException(463, "Failed to drop all resources for resource processor '" + rpName + "'!", e);
            }
        }
    }

    private class RollbackCommitAction
    implements Runnable {
        private final DeploymentSessionImpl m_session;

        public RollbackCommitAction(DeploymentSessionImpl session) {
            this.m_session = session;
        }

        public void run() {
            DropAllResourcesCommand.this.m_commitCommand.rollback(this.m_session);
        }
    }
}

