/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.internal.rpc;

import java.io.InputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.deploymentadmin.BundleInfo;
import org.osgi.service.deploymentadmin.DeploymentAdmin;
import org.osgi.service.deploymentadmin.DeploymentPackage;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.tigris.mtoolkit.iagent.Error;
import org.tigris.mtoolkit.iagent.internal.rpc.Activator;
import org.tigris.mtoolkit.iagent.internal.rpc.DefaultDeploymentManagerDelegate;
import org.tigris.mtoolkit.iagent.internal.rpc.DeploymentEventListener;
import org.tigris.mtoolkit.iagent.internal.utils.DebugUtils;
import org.tigris.mtoolkit.iagent.rpc.Remote;
import org.tigris.mtoolkit.iagent.rpc.RemoteCapabilitiesManager;
import org.tigris.mtoolkit.iagent.rpc.RemoteDeploymentAdmin;
import org.tigris.mtoolkit.iagent.rpc.spi.DeploymentManagerDelegate;

public class RemoteDeploymentAdminImpl
implements Remote,
RemoteDeploymentAdmin {
    private static final String EVENT_ADMIN_CLASS = "org.osgi.service.event.EventAdmin";
    private ServiceRegistration registration;
    private EventAdminTracker eventAdminTrack;
    private ServiceTracker delegatesTrack;
    private BundleContext context;
    private DeploymentAdmin deploymentAdmin;
    private DeploymentManagerDelegate defaultDelegate;
    private DeploymentEventListener listener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void register(BundleContext bc, Object admin) {
        this.debug("[register] Registering remote Deployment Admin...");
        this.context = bc;
        this.deploymentAdmin = (DeploymentAdmin)admin;
        this.defaultDelegate = new DefaultDeploymentManagerDelegate(this.deploymentAdmin);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.tigris.mtoolkit.iagent.rpc.spi.DeploymentManagerDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.delegatesTrack = new ServiceTracker(this.context, clazz.getName(), null);
        this.delegatesTrack.open();
        this.eventAdminTrack = new EventAdminTracker(this.context, EVENT_ADMIN_CLASS, null);
        this.eventAdminTrack.open(true);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.tigris.mtoolkit.iagent.rpc.RemoteDeploymentAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registration = this.context.registerService(clazz2.getName(), (Object)this, null);
        RemoteCapabilitiesManager capMan = Activator.getCapabilitiesManager();
        if (capMan != null) {
            capMan.setCapability("remote.deployment.support", new Boolean(true));
        }
        this.debug("[removedService] Remote Deployment Admin Registered.");
    }

    public void unregister(BundleContext bc) {
        RemoteCapabilitiesManager capMan;
        this.debug("[unregister] Unregistering...");
        if (this.eventAdminTrack != null) {
            this.eventAdminTrack.close();
            this.eventAdminTrack = null;
        }
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        if ((capMan = Activator.getCapabilitiesManager()) != null) {
            capMan.setCapability("remote.deployment.support", new Boolean(false));
        }
        this.context = null;
        this.debug("[unregister] Unregistered.");
    }

    public DeploymentAdmin getDeploymentAdmin() {
        return this.deploymentAdmin;
    }

    private void registerListener() {
        if (this.listener != null) {
            return;
        }
        this.listener = new DeploymentEventListener();
        this.listener.register(this.context, this.deploymentAdmin);
    }

    private void unregisterListener() {
        if (this.listener != null) {
            this.listener.unregister();
            this.listener = null;
        }
    }

    public Dictionary listDeploymentPackages() {
        this.debug("[listDeploymentPackages] >>>");
        DeploymentAdmin admin = this.internalGetDeploymentAdmin();
        DeploymentPackage[] packages = admin.listDeploymentPackages();
        Hashtable<String, String> result = new Hashtable<String, String>();
        int i = 0;
        while (i < packages.length) {
            DeploymentPackage dp = packages[i];
            ((Dictionary)result).put(dp.getName(), dp.getVersion().toString());
            ++i;
        }
        this.debug("[listDeploymentPackages] Deployment packages: " + DebugUtils.convertForDebug(result));
        return result;
    }

    public Object getDeploymentPackageHeader(String name, String version, String headerName) {
        this.debug("[getDeploymentPackageHeader] >> dpName: " + name + "; version: " + version + "; headerName: " + headerName);
        DeploymentPackage dp = this.internalGetDeploymentPackage(name, version);
        if (dp == null) {
            Error error = new Error(-10001, "Deployment package " + name + " (" + version + ") has been uninstalled");
            this.info("[getDeploymentPackageHeader] No such deployment package: " + error);
            return error;
        }
        String deploymentPackageHeader = dp.getHeader(headerName);
        this.debug("[getDeploymentPackageHeader] Header value: " + deploymentPackageHeader);
        return deploymentPackageHeader;
    }

    public Dictionary getDeploymentPackageBundles(String name, String version) {
        this.debug("[getDeploymentPackageBundles] >>> dpName: " + name + "; version: " + version);
        DeploymentPackage dp = this.internalGetDeploymentPackage(name, version);
        if (dp == null) {
            this.info("[getDeploymentPackageBundles] No such deployment package");
            return null;
        }
        BundleInfo[] bundleInfos = dp.getBundleInfos();
        Hashtable<String, String> result = new Hashtable<String, String>();
        int i = 0;
        while (i < bundleInfos.length) {
            BundleInfo bundleInfo = bundleInfos[i];
            ((Dictionary)result).put(bundleInfo.getSymbolicName(), bundleInfo.getVersion().toString());
            ++i;
        }
        this.debug("[getDeploymentPackageBundles] bundles: " + DebugUtils.convertForDebug(result));
        return result;
    }

    public long getDeploymentPackageBundle(String dpName, String version, String symbolicName) {
        this.debug("[getDeploymentPackageBundle] >>> dpName: " + dpName + "; version: " + version + "; symbolicName: " + symbolicName);
        DeploymentPackage dp = this.internalGetDeploymentPackage(dpName, version);
        if (dp == null) {
            this.info("[getDeploymentPackageBundle] No such deployment package");
            return -2L;
        }
        Bundle bundle = dp.getBundle(symbolicName);
        if (bundle != null) {
            long bundleID = bundle.getBundleId();
            this.debug("[getDeploymentPackageBundle] bundle id: " + bundleID);
            return bundleID;
        }
        this.info("[getDeploymentPackageBundle] No such bundle");
        return -1L;
    }

    public Object uninstallDeploymentPackage(String dpName, String version, boolean force) {
        this.debug("[uninstallDeploymentPackage] >>> dpName: " + dpName + "; version: " + version + "; force: " + force);
        DeploymentPackage dp = this.internalGetDeploymentPackage(dpName, version);
        if (dp == null) {
            Error error = new Error(-10001, "Deployment package " + dpName + " (" + version + ") has been uninstalled");
            this.info("[uninstallDeploymentPackage] No such deployment package: " + error);
            return error;
        }
        Object result = this.getDelegate().uninstallDeploymentPackage(dp, force);
        if (Boolean.TRUE.equals(result)) {
            this.debug("[uninstallDeploymentPackage] DP uninstalled");
        } else if (Boolean.FALSE.equals(result)) {
            this.info("[uninstallDeploymentPackage] DP uninstalled unsuccessful");
        } else if (result instanceof Error) {
            this.info("[uninstallDeploymentPackage] Unable to uninstall dp: " + result);
        }
        return result;
    }

    public boolean isDeploymentPackageStale(String dpName, String version) {
        this.debug("[isDeploymentPackageStale] >>> dpName: " + dpName + "; version: " + version);
        DeploymentAdmin admin = this.internalGetDeploymentAdmin();
        DeploymentPackage dp = admin.getDeploymentPackage(dpName);
        if (dp != null && dp.getVersion().toString().equals(version)) {
            this.debug("[isDeploymentPackageStale] DP is not stale");
            return false;
        }
        this.debug("[isDeploymentPackageStale] DP is stale");
        return true;
    }

    private DeploymentPackage internalGetDeploymentPackage(String name, String version) {
        DeploymentAdmin admin = this.internalGetDeploymentAdmin();
        DeploymentPackage dp = admin.getDeploymentPackage(name);
        if (dp != null && dp.getVersion().toString().equals(version)) {
            return dp;
        }
        return null;
    }

    public String getDeploymentPackageVersion(String dpName) {
        this.debug("[getDeploymentPackageVersion] >>> dpName: " + dpName);
        DeploymentAdmin admin = this.internalGetDeploymentAdmin();
        DeploymentPackage dp = admin.getDeploymentPackage(dpName);
        if (dp != null) {
            String dpVersion = dp.getVersion().toString();
            this.debug("[getDeploymentPackageVersion] version: " + dpVersion);
            return dpVersion;
        }
        this.info("[getDeploymentPackageVersion] No deployment package with this symbolic name found");
        return null;
    }

    private DeploymentAdmin internalGetDeploymentAdmin() {
        DeploymentAdmin admin = this.deploymentAdmin;
        if (admin == null) {
            this.info("[internalGetDeploymentAdmin] DeploymentAdmin has been unregistered.");
            throw new IllegalStateException("DeploymentAdmin is not available");
        }
        return admin;
    }

    public Object installDeploymentPackage(InputStream in) {
        this.debug("[installDeploymentPackage] >>> in: " + in);
        Object result = this.getDelegate().installDeploymentPackage(in);
        if (result instanceof Error) {
            this.info("[installDeploymentPackage] Unable to install DeploymentPackage: " + result);
            return result;
        }
        DeploymentPackage dp = (DeploymentPackage)result;
        String name = dp.getName();
        String version = dp.getVersion().toString();
        this.debug("[installDeploymentPackage] deployment package installation successful: " + name + "_" + version);
        return new String[]{name, version};
    }

    private DeploymentManagerDelegate getDelegate() {
        DeploymentManagerDelegate delegate = (DeploymentManagerDelegate)this.delegatesTrack.getService();
        if (delegate != null) {
            return delegate;
        }
        return this.defaultDelegate;
    }

    public Class[] remoteInterfaces() {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.tigris.mtoolkit.iagent.rpc.RemoteDeploymentAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return classArray;
    }

    public long getRemoteServiceID() {
        ServiceReference localRef;
        block5: {
            ServiceRegistration localRegistration;
            block4: {
                try {
                    localRegistration = this.registration;
                    if (localRegistration != null) break block4;
                    return -1L;
                }
                catch (IllegalStateException illegalStateException) {
                    return -1L;
                }
            }
            localRef = localRegistration.getReference();
            if (localRef != null) break block5;
            return -1L;
        }
        return (Long)localRef.getProperty("service.id");
    }

    private final void debug(String message) {
        DebugUtils.debug(this, message);
    }

    private final void info(String message) {
        DebugUtils.info(this, message);
    }

    private class EventAdminTracker
    extends ServiceTracker {
        private EventAdminTracker(BundleContext context, String clazz, ServiceTrackerCustomizer customizer) {
            super(context, clazz, customizer);
        }

        public Object addingService(ServiceReference reference) {
            RemoteDeploymentAdminImpl.this.registerListener();
            return super.addingService(reference);
        }

        public void removedService(ServiceReference reference, Object service) {
            super.removedService(reference, service);
            if (this.getService() == null) {
                RemoteDeploymentAdminImpl.this.unregisterListener();
            }
        }
    }
}

