/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.cloudconnection.eclipseiot.mqtt.cloud;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.Map;
import org.eclipse.kura.KuraInvalidMetricTypeException;
import org.eclipse.kura.internal.cloudconnection.eclipseiot.mqtt.cloud.CloudPayloadEncoder;
import org.eclipse.kura.internal.cloudconnection.eclipseiot.mqtt.message.protobuf.KuraPayloadProto;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.message.KuraPosition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudPayloadProtoBufEncoderImpl
implements CloudPayloadEncoder {
    private static final Logger logger = LoggerFactory.getLogger(CloudPayloadProtoBufEncoderImpl.class);
    private final KuraPayload kuraPayload;

    public CloudPayloadProtoBufEncoderImpl(KuraPayload kuraPayload) {
        this.kuraPayload = kuraPayload;
    }

    @Override
    public byte[] getBytes() throws IOException {
        KuraPayloadProto.KuraPayload.Builder protoMsg = KuraPayloadProto.KuraPayload.newBuilder();
        if (this.kuraPayload.getTimestamp() != null) {
            protoMsg.setTimestamp(this.kuraPayload.getTimestamp().getTime());
        }
        if (this.kuraPayload.getPosition() != null) {
            protoMsg.setPosition(this.buildPositionProtoBuf());
        }
        for (Map.Entry entry : this.kuraPayload.metrics().entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            try {
                KuraPayloadProto.KuraPayload.KuraMetric.Builder metricB = KuraPayloadProto.KuraPayload.KuraMetric.newBuilder();
                metricB.setName(name);
                boolean result = CloudPayloadProtoBufEncoderImpl.setProtoKuraMetricValue(metricB, value);
                if (!result) continue;
                protoMsg.addMetric(metricB);
            }
            catch (KuraInvalidMetricTypeException e) {
                logger.error("During serialization, ignoring metric named: {}. Unrecognized value type: {}.", (Object)name, (Object)(value != null ? value.getClass().getName() : "<null>"));
                throw new RuntimeException(e);
            }
        }
        if (this.kuraPayload.getBody() != null) {
            protoMsg.setBody(ByteString.copyFrom((byte[])this.kuraPayload.getBody()));
        }
        return protoMsg.build().toByteArray();
    }

    private KuraPayloadProto.KuraPayload.KuraPosition buildPositionProtoBuf() {
        KuraPayloadProto.KuraPayload.KuraPosition.Builder protoPos = KuraPayloadProto.KuraPayload.KuraPosition.newBuilder();
        KuraPosition position = this.kuraPayload.getPosition();
        if (position.getLatitude() != null) {
            protoPos.setLatitude(position.getLatitude());
        }
        if (position.getLongitude() != null) {
            protoPos.setLongitude(position.getLongitude());
        }
        if (position.getAltitude() != null) {
            protoPos.setAltitude(position.getAltitude());
        }
        if (position.getPrecision() != null) {
            protoPos.setPrecision(position.getPrecision());
        }
        if (position.getHeading() != null) {
            protoPos.setHeading(position.getHeading());
        }
        if (position.getSpeed() != null) {
            protoPos.setSpeed(position.getSpeed());
        }
        if (position.getTimestamp() != null) {
            protoPos.setTimestamp(position.getTimestamp().getTime());
        }
        if (position.getSatellites() != null) {
            protoPos.setSatellites(position.getSatellites());
        }
        if (position.getStatus() != null) {
            protoPos.setStatus(position.getStatus());
        }
        return protoPos.build();
    }

    private static boolean setProtoKuraMetricValue(KuraPayloadProto.KuraPayload.KuraMetric.Builder metric, Object o) throws KuraInvalidMetricTypeException {
        if (o instanceof String) {
            metric.setType(KuraPayloadProto.KuraPayload.KuraMetric.ValueType.STRING);
            metric.setStringValue((String)o);
        } else if (o instanceof Double) {
            metric.setType(KuraPayloadProto.KuraPayload.KuraMetric.ValueType.DOUBLE);
            metric.setDoubleValue((Double)o);
        } else if (o instanceof Integer) {
            metric.setType(KuraPayloadProto.KuraPayload.KuraMetric.ValueType.INT32);
            metric.setIntValue((Integer)o);
        } else if (o instanceof Float) {
            metric.setType(KuraPayloadProto.KuraPayload.KuraMetric.ValueType.FLOAT);
            metric.setFloatValue(((Float)o).floatValue());
        } else if (o instanceof Long) {
            metric.setType(KuraPayloadProto.KuraPayload.KuraMetric.ValueType.INT64);
            metric.setLongValue((Long)o);
        } else if (o instanceof Boolean) {
            metric.setType(KuraPayloadProto.KuraPayload.KuraMetric.ValueType.BOOL);
            metric.setBoolValue((Boolean)o);
        } else if (o instanceof byte[]) {
            metric.setType(KuraPayloadProto.KuraPayload.KuraMetric.ValueType.BYTES);
            metric.setBytesValue(ByteString.copyFrom((byte[])((byte[])o)));
        } else {
            if (o == null) {
                logger.warn("Received a metric with a null value!");
                return false;
            }
            throw new KuraInvalidMetricTypeException((Object)o.getClass().getName());
        }
        return true;
    }
}

