/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.server.netty;

import io.moquette.proto.Utils;
import io.moquette.proto.messages.AbstractMessage;
import io.moquette.proto.messages.ConnectMessage;
import io.moquette.proto.messages.PingRespMessage;
import io.moquette.proto.messages.PubAckMessage;
import io.moquette.proto.messages.PubCompMessage;
import io.moquette.proto.messages.PubRecMessage;
import io.moquette.proto.messages.PubRelMessage;
import io.moquette.proto.messages.PublishMessage;
import io.moquette.proto.messages.SubscribeMessage;
import io.moquette.proto.messages.UnsubscribeMessage;
import io.moquette.server.netty.NettyUtils;
import io.moquette.spi.impl.ProtocolProcessor;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.CorruptedFrameException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class NettyMQTTHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(NettyMQTTHandler.class);
    private final ProtocolProcessor m_processor;

    public NettyMQTTHandler(ProtocolProcessor processor) {
        this.m_processor = processor;
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object message) {
        AbstractMessage msg = (AbstractMessage)message;
        LOG.info("Received a message of type {}", (Object)Utils.msgType2String(msg.getMessageType()));
        try {
            switch (msg.getMessageType()) {
                case 1: {
                    this.m_processor.processConnect(ctx.channel(), (ConnectMessage)msg);
                    break;
                }
                case 8: {
                    this.m_processor.processSubscribe(ctx.channel(), (SubscribeMessage)msg);
                    break;
                }
                case 10: {
                    this.m_processor.processUnsubscribe(ctx.channel(), (UnsubscribeMessage)msg);
                    break;
                }
                case 3: {
                    this.m_processor.processPublish(ctx.channel(), (PublishMessage)msg);
                    break;
                }
                case 5: {
                    this.m_processor.processPubRec(ctx.channel(), (PubRecMessage)msg);
                    break;
                }
                case 7: {
                    this.m_processor.processPubComp(ctx.channel(), (PubCompMessage)msg);
                    break;
                }
                case 6: {
                    this.m_processor.processPubRel(ctx.channel(), (PubRelMessage)msg);
                    break;
                }
                case 14: {
                    this.m_processor.processDisconnect(ctx.channel());
                    break;
                }
                case 4: {
                    this.m_processor.processPubAck(ctx.channel(), (PubAckMessage)msg);
                    break;
                }
                case 12: {
                    PingRespMessage pingResp = new PingRespMessage();
                    ctx.writeAndFlush(pingResp);
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Bad error in processing the message", ex);
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        String clientID = NettyUtils.clientID(ctx.channel());
        if (clientID != null && !clientID.isEmpty()) {
            boolean stolen = false;
            Boolean stolenAttr = NettyUtils.sessionStolen(ctx.channel());
            if (stolenAttr != null && stolenAttr == Boolean.TRUE) {
                stolen = true;
            }
            this.m_processor.processConnectionLost(clientID, stolen, ctx.channel());
        }
        ctx.close();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof CorruptedFrameException) {
            LOG.warn("Error decoding a packet, probably a bad formatted packet, message: " + cause.getMessage());
        } else {
            LOG.error("Ugly error on networking", cause);
        }
        ctx.close();
    }
}

