/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.timer;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.internal.wire.timer.EmitJob;
import org.eclipse.kura.internal.wire.timer.TimerJobDataMap;
import org.eclipse.kura.internal.wire.timer.TimerOptions;
import org.eclipse.kura.wire.WireComponent;
import org.eclipse.kura.wire.WireEmitter;
import org.eclipse.kura.wire.WireHelperService;
import org.eclipse.kura.wire.WireSupport;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.wireadmin.Wire;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class Timer
implements WireEmitter,
ConfigurableComponent {
    private static final String GROUP_ID = "wires";
    private static AtomicInteger nextJobId = new AtomicInteger(0);
    private static final Logger logger = LogManager.getLogger(Timer.class);
    private JobKey jobKey;
    private TimerOptions timerOptions;
    private volatile WireHelperService wireHelperService;
    private WireSupport wireSupport;
    private static final AtomicInteger instanceCount = new AtomicInteger(0);
    private static Scheduler scheduler = null;

    public void bindWireHelperService(WireHelperService wireHelperService) {
        if (Objects.isNull(this.wireHelperService)) {
            this.wireHelperService = wireHelperService;
        }
    }

    public void unbindWireHelperService(WireHelperService wireHelperService) {
        if (this.wireHelperService == wireHelperService) {
            this.wireHelperService = null;
        }
    }

    protected void activate(ComponentContext ctx, Map<String, Object> properties) {
        logger.debug("Activating Timer...");
        instanceCount.incrementAndGet();
        this.wireSupport = this.wireHelperService.newWireSupport((WireComponent)this, ctx.getServiceReference());
        this.timerOptions = new TimerOptions(properties);
        try {
            this.doUpdate();
        }
        catch (SchedulerException e) {
            logger.error("Scheduler exception.", (Throwable)e);
        }
        logger.debug("Activating Timer... Done");
    }

    protected void updated(Map<String, Object> properties) {
        logger.debug("Updating Timer...");
        this.timerOptions = new TimerOptions(properties);
        try {
            this.doUpdate();
        }
        catch (SchedulerException e) {
            logger.error("Scheduler exception.", (Throwable)e);
        }
        logger.debug("Updating Timer... Done");
    }

    protected void deactivate(ComponentContext ctx) {
        block9: {
            logger.debug("Dectivating Timer...");
            try {
                try {
                    if (Objects.nonNull(this.jobKey)) {
                        this.getScheduler().deleteJob(this.jobKey);
                    }
                }
                catch (SchedulerException e) {
                    logger.error("Scheduler exception.", (Throwable)e);
                    if (instanceCount.decrementAndGet() == 0) {
                        Timer.shutdownScheduler();
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (instanceCount.decrementAndGet() == 0) {
                    Timer.shutdownScheduler();
                }
                throw throwable;
            }
            if (instanceCount.decrementAndGet() == 0) {
                Timer.shutdownScheduler();
            }
        }
        logger.debug("Dectivating Timer... Done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Scheduler getScheduler() throws SchedulerException {
        AtomicInteger atomicInteger = instanceCount;
        synchronized (atomicInteger) {
            if (scheduler == null) {
                scheduler = new StdSchedulerFactory().getScheduler();
                scheduler.start();
            }
        }
        return scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void shutdownScheduler() {
        AtomicInteger atomicInteger = instanceCount;
        synchronized (atomicInteger) {
            if (scheduler != null) {
                try {
                    scheduler.shutdown();
                }
                catch (SchedulerException e) {
                    logger.warn("Scheduler exception.", (Throwable)e);
                }
                scheduler = null;
            }
        }
    }

    private void doUpdate() throws SchedulerException {
        if ("SIMPLE".equalsIgnoreCase(this.timerOptions.getType())) {
            this.scheduleSimpleInterval((long)this.timerOptions.getSimpleInterval() * this.timerOptions.getSimpleTimeUnitMultiplier());
            return;
        }
        String cronExpression = this.timerOptions.getCronExpression();
        this.scheduleCronInterval(cronExpression);
    }

    private void scheduleSimpleInterval(long interval) throws SchedulerException {
        if (interval <= 0L) {
            throw new IllegalArgumentException("Interval cannot be less than or equal to zero");
        }
        Scheduler scheduler = this.getScheduler();
        int id = nextJobId.incrementAndGet();
        if (Objects.nonNull(this.jobKey)) {
            scheduler.deleteJob(this.jobKey);
        }
        this.jobKey = new JobKey("emitJob" + id, GROUP_ID);
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity("emitTrigger" + id, GROUP_ID).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(interval).repeatForever()).build();
        TimerJobDataMap jobDataMap = new TimerJobDataMap();
        jobDataMap.putWireSupport(this.wireSupport);
        JobDetail job = JobBuilder.newJob(EmitJob.class).withIdentity(this.jobKey).setJobData((JobDataMap)jobDataMap).build();
        scheduler.scheduleJob(job, trigger);
    }

    private void scheduleCronInterval(String expression) throws SchedulerException {
        Objects.requireNonNull(expression, "Cron Expression cannot be null");
        Scheduler scheduler = this.getScheduler();
        int id = nextJobId.incrementAndGet();
        if (Objects.nonNull(this.jobKey)) {
            scheduler.deleteJob(this.jobKey);
        }
        this.jobKey = new JobKey("emitJob" + id, GROUP_ID);
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity("emitTrigger" + id, GROUP_ID).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)expression)).build();
        TimerJobDataMap jobDataMap = new TimerJobDataMap();
        jobDataMap.putWireSupport(this.wireSupport);
        JobDetail job = JobBuilder.newJob(EmitJob.class).withIdentity(this.jobKey).setJobData((JobDataMap)jobDataMap).build();
        scheduler.getContext().put("wireSupport", (Object)this.wireSupport);
        scheduler.scheduleJob(job, trigger);
    }

    public void consumersConnected(Wire[] wires) {
        this.wireSupport.consumersConnected(wires);
    }

    public Object polled(Wire wire) {
        return this.wireSupport.polled(wire);
    }
}

