/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.channel;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.eclipse.kura.annotation.NotThreadSafe;
import org.eclipse.kura.channel.ChannelRecord;
import org.eclipse.kura.channel.ChannelType;
import org.eclipse.kura.type.DataType;
import org.eclipse.kura.type.TypedValue;
import org.osgi.annotation.versioning.ProviderType;

@NotThreadSafe
@ProviderType
public class Channel {
    private final transient Map<String, Object> configuration;
    private String name;
    private ChannelType type;
    private DataType valueType;
    private boolean isEnabled = true;

    public Channel(String name, ChannelType type, DataType valueType, Map<String, Object> config) {
        Objects.requireNonNull(name, "Channel name cannot be null");
        Objects.requireNonNull(type, "Channel type cannot be null");
        Objects.requireNonNull(valueType, "Channel value type cannot be null");
        Objects.requireNonNull(config, "Channel configuration cannot be null");
        this.configuration = Collections.unmodifiableMap(config);
        this.name = name;
        this.type = type;
        this.valueType = valueType;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public String getName() {
        return this.name;
    }

    public ChannelType getType() {
        return this.type;
    }

    public DataType getValueType() {
        return this.valueType;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setName(String name) {
        Objects.requireNonNull(name, "Channel name cannot be null");
        this.name = name;
    }

    public void setType(ChannelType type) {
        Objects.requireNonNull(type, "Channel type cannot be null");
        this.type = type;
    }

    public void setValueType(DataType valueType) {
        Objects.requireNonNull(valueType, "Channel value type cannot be null");
        this.valueType = valueType;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public String toString() {
        return "Channel [configuration=" + this.configuration + ", name=" + this.name + ", type=" + (Object)((Object)this.type) + ", valueType=" + (Object)((Object)this.valueType) + "]";
    }

    public ChannelRecord createReadRecord() {
        ChannelRecord result = ChannelRecord.createReadRecord(this.name, this.valueType);
        result.setChannelConfig(this.configuration);
        return result;
    }

    public ChannelRecord createWriteRecord(TypedValue<?> value) {
        Objects.requireNonNull(value, "Value cannot be null");
        if (value.getType() != this.valueType) {
            throw new IllegalArgumentException("The value type of the argument must match the channel value type");
        }
        ChannelRecord result = ChannelRecord.createWriteRecord(this.name, value);
        result.setChannelConfig(this.configuration);
        return result;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.configuration == null ? 0 : this.configuration.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.valueType == null ? 0 : this.valueType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Channel other = (Channel)obj;
        if (this.configuration == null ? other.configuration != null : !this.configuration.equals(other.configuration)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return this.valueType == other.valueType;
    }
}

