/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.drivers.assets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import org.eclipse.kura.web.client.configuration.HasConfiguration;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.client.ui.AlertDialog;
import org.gwtbootstrap3.client.ui.Button;

public class ConfigurationUiButtons
extends Composite
implements HasConfiguration.Listener {
    private static ConfigurationUiButtonsUiBinder uiBinder = (ConfigurationUiButtonsUiBinder)GWT.create(ConfigurationUiButtonsUiBinder.class);
    private static final Messages MSGS = (Messages)GWT.create(Messages.class);
    @UiField
    Button btnApply;
    @UiField
    Button btnReset;
    @UiField
    AlertDialog confirmDialog;
    private Listener listener;

    public ConfigurationUiButtons(final HasConfiguration target) {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.btnApply.setEnabled(target.isDirty());
        this.btnReset.setEnabled(target.isDirty());
        target.setListener(this);
        this.btnApply.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (ConfigurationUiButtons.this.listener == null) {
                    return;
                }
                if (!target.isValid()) {
                    ConfigurationUiButtons.this.confirmDialog.show(MSGS.formWithErrorsOrIncomplete(), AlertDialog.Severity.ALERT, null);
                    return;
                }
                ConfigurationUiButtons.this.confirmDialog.show(MSGS.deviceConfigConfirmationNoName(), new AlertDialog.Listener(){

                    @Override
                    public void onConfirm() {
                        ConfigurationUiButtons.this.listener.onApply();
                    }
                });
            }
        });
        this.btnReset.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (ConfigurationUiButtons.this.listener == null) {
                    return;
                }
                ConfigurationUiButtons.this.confirmDialog.show(MSGS.deviceConfigDirty(), new AlertDialog.Listener(){

                    @Override
                    public void onConfirm() {
                        ConfigurationUiButtons.this.listener.onReset();
                    }
                });
            }
        });
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    @Override
    public void onConfigurationChanged(HasConfiguration hasConfiguration) {
    }

    @Override
    public void onDirtyStateChanged(HasConfiguration hasConfiguration) {
        boolean isDirty = hasConfiguration.isDirty();
        this.btnApply.setEnabled(isDirty);
        this.btnReset.setEnabled(isDirty);
    }

    static interface ConfigurationUiButtonsUiBinder
    extends UiBinder<Widget, ConfigurationUiButtons> {
    }

    public static interface Listener {
        public void onApply();

        public void onReset();
    }
}

