/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import org.eclipse.kura.web.client.messages.Messages;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.ModalFooter;
import org.gwtbootstrap3.client.ui.base.HasId;
import org.gwtbootstrap3.client.ui.html.Span;
import org.gwtbootstrap3.client.ui.html.Strong;

public class AlertDialog
extends Composite
implements HasId {
    private static AlertDialogUiBinder uiBinder = (AlertDialogUiBinder)GWT.create(AlertDialogUiBinder.class);
    private static final Messages MSGS = (Messages)GWT.create(Messages.class);
    private Listener listener;
    @UiField
    Button yes;
    @UiField
    Button no;
    @UiField
    ModalFooter alertFooter;
    @UiField
    Span messageText;
    @UiField
    Alert alertBody;
    @UiField
    Strong alertText;
    private final Modal modal = (Modal)uiBinder.createAndBindUi((Object)this);

    public AlertDialog() {
        this.initWidget((Widget)this.modal);
        this.modal.setHideOtherModals(false);
        this.modal.setTitle(MSGS.confirm());
        this.yes.setText(MSGS.yesButton());
        this.no.setText(MSGS.noButton());
        this.yes.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (AlertDialog.this.listener != null) {
                    AlertDialog.this.listener.onConfirm();
                }
                AlertDialog.this.modal.hide();
            }
        });
        this.no.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                AlertDialog.this.modal.hide();
            }
        });
    }

    public void setListener(Listener listener) {
        this.listener = listener;
        this.alertFooter.setVisible(listener != null);
    }

    public void show(String title, String message, Severity severity, Listener listener) {
        this.setAlertText(message, severity);
        this.setTitle(title);
        this.setListener(listener);
        this.modal.show();
    }

    public void show(String message, Listener listener) {
        this.show(MSGS.confirm(), message, Severity.INFO, listener);
    }

    public void show(String message, Severity severity, Listener listener) {
        this.show(severity == Severity.INFO ? MSGS.confirm() : MSGS.warning(), message, severity, listener);
    }

    public void show(String title, String message, Listener listener) {
        this.show(title, message, Severity.INFO, listener);
    }

    public void setAlertText(String message, Severity severity) {
        if (severity == Severity.INFO) {
            this.messageText.setText(message);
            this.messageText.setVisible(true);
            this.alertBody.setVisible(false);
        } else {
            this.alertText.setText(message);
            this.alertBody.setVisible(true);
            this.messageText.setVisible(false);
        }
    }

    public String getId() {
        return this.modal.getId();
    }

    public void setId(String id) {
        this.modal.setId(id);
    }

    public void setTitle(String title) {
        this.modal.setTitle(title);
    }

    static interface AlertDialogUiBinder
    extends UiBinder<Widget, AlertDialog> {
    }

    public static interface Listener {
        public void onConfirm();
    }

    public static enum Severity {
        INFO,
        ALERT;

    }
}

