/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.emde.extension.utils;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;
import org.polarsys.kitalpha.emde.extension.utils.Log;

public class EMFHelper {
    public static EClassifier solveAgainstStaticPackage(EClassifier eClassifier) {
        if (eClassifier == null) {
            return null;
        }
        EPackage ePackage = EMFHelper.getStaticPackage(EMFHelper.getRootPackage(eClassifier.getEPackage()));
        if (ePackage != null && ePackage.eResource() != null) {
            EClassifier solvedEClassifier;
            URI uri = EcoreUtil.getURI((EObject)eClassifier);
            if (uri == null) {
                return eClassifier;
            }
            EObject eObject = ePackage.eResource().getEObject(uri.fragment());
            if (eObject == null) {
                return eClassifier;
            }
            Object object = solvedEClassifier = eObject instanceof EClassifier ? (EClassifier)eObject : eObject.eClass();
            if (solvedEClassifier != null) {
                return solvedEClassifier;
            }
        } else {
            Log.getDefault().logWarning(NLS.bind((String)"Unable to solve EClassifier {0} against its static EPackage", (Object)eClassifier));
        }
        return eClassifier;
    }

    public static EPackage getRootPackage(EPackage ePackage) {
        if (ePackage == null) {
            return null;
        }
        EPackage result = null;
        EPackage rootPackage = ePackage;
        while (rootPackage != null) {
            result = rootPackage;
            rootPackage = result.getESuperPackage();
        }
        if (result == null) {
            Log.getDefault().logWarning(NLS.bind((String)"Unable to solve a Root EPackage for {0}", (Object)ePackage));
        }
        return result;
    }

    public static EPackage getStaticPackage(EPackage ePackage) {
        if (ePackage == null) {
            return null;
        }
        EPackage ePackageStatic = null;
        Object staticPackage = null;
        if (ePackage.getNsURI() != null) {
            staticPackage = EPackage.Registry.INSTANCE.get((Object)ePackage.getNsURI());
        }
        if (staticPackage != null) {
            if (staticPackage instanceof EPackage) {
                ePackageStatic = (EPackage)staticPackage;
            } else if (staticPackage instanceof EPackage.Descriptor) {
                ePackageStatic = ((EPackage.Descriptor)staticPackage).getEPackage();
            }
        } else {
            ePackageStatic = ePackage;
        }
        return ePackageStatic;
    }
}

