/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpbuild;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ProtocolType implements Enumerator
{
    GIT(0, "git", "git"),
    SVN(1, "svn", "svn"),
    SVNSSH(2, "svnssh", "svnssh");

    public static final int GIT_VALUE = 0;
    public static final int SVN_VALUE = 1;
    public static final int SVNSSH_VALUE = 2;
    private static final ProtocolType[] VALUES_ARRAY;
    public static final List<ProtocolType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ProtocolType[]{GIT, SVN, SVNSSH};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ProtocolType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ProtocolType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ProtocolType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ProtocolType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ProtocolType get(int value) {
        switch (value) {
            case 0: {
                return GIT;
            }
            case 1: {
                return SVN;
            }
            case 2: {
                return SVNSSH;
            }
        }
        return null;
    }

    private ProtocolType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

