/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.report.ui.views;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Control;
import org.polarsys.kitalpha.report.model.Severity;
import org.polarsys.kitalpha.report.registry.ReportRegistry;
import org.polarsys.kitalpha.report.ui.Activator;
import org.polarsys.kitalpha.report.ui.views.MenuCreatorAction;
import org.polarsys.kitalpha.report.ui.views.ReportsView;

public class SetSeverityFilterAction
extends MenuCreatorAction {
    private final ReportsView view;

    public SetSeverityFilterAction(ReportsView view) {
        this.view = view;
        this.setToolTipText("Filter displayed reports");
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/severityFilter.png"));
    }

    @Override
    protected void fillMenu(Control parent) {
        Severity threshold = this.computeSeverityThreshold();
        for (Severity elt : ReportRegistry.INSTANCE.getSeverities()) {
            ChooseSeverityAction action = new ChooseSeverityAction(elt);
            if (elt == threshold) {
                action.setChecked(true);
            }
            this.addActionToMenu(this.menu, action);
        }
    }

    private Severity computeSeverityThreshold() {
        Severity lowerOne = null;
        for (Severity elt : ReportRegistry.INSTANCE.getSeverities()) {
            if (elt.getCode() == this.view.getSeverityThreshold()) {
                return elt;
            }
            if (elt.getCode() > this.view.getSeverityThreshold()) {
                lowerOne = elt;
                continue;
            }
            return lowerOne;
        }
        return null;
    }

    class ChooseSeverityAction
    extends Action {
        private final Severity elt;

        public ChooseSeverityAction(Severity elt) {
            super(elt.getLabel(), 8);
            this.elt = elt;
        }

        public void run() {
            SetSeverityFilterAction.this.view.setSeverityThreshold(this.elt.getCode());
        }
    }
}

