/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.contentassist;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ITemplateAcceptor;
import org.eclipse.xtext.ui.editor.templates.ContextTypeIdHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.AbstractAssociation;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.AbstractSuperClass;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Attribute;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Class;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Data;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Enumeration;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.ExternalAttributeType;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.LocalAttributeType;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.LocalSuperClass;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.resources.ResourceHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.contentassist.CommonTemplateProposalProvider;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.contentassist.output.TreeAppendable;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.internal.VpuiActivator;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint;

public class VpuiTemplateProposalProvider
extends CommonTemplateProposalProvider {
    private ResourceSet resourceSet;
    @Inject
    private IValueConverterService valueConverter;
    private int counter = 1;
    private final Set<String> namesTracker = new HashSet<String>();

    @Inject
    public VpuiTemplateProposalProvider(TemplateStore templateStore, ContextTypeRegistry registry, ContextTypeIdHelper helper) {
        super(templateStore, registry, helper);
        this.templateStore = templateStore;
    }

    protected void createTemplates(TemplateContext templateContext, ContentAssistContext context, ITemplateAcceptor acceptor) {
        Template template;
        Template[] templates;
        TemplateContextType contextType = templateContext.getContextType();
        Template[] templateArray = templates = this.templateStore.getTemplates(contextType.getId());
        int n = templates.length;
        int n2 = 0;
        while (n2 < n) {
            template = templateArray[n2];
            if (template.getDescription().equals("Generate User Interface for all classes")) {
                template = this.buildUIGenerationTemplate(template, context);
            }
            ++n2;
        }
        templateArray = templates;
        n = templates.length;
        n2 = 0;
        while (n2 < n) {
            template = templateArray[n2];
            if (!acceptor.canAcceptMoreTemplates()) {
                return;
            }
            if (this.validate(template, templateContext)) {
                TemplateProposal proposal = this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template));
                acceptor.accept(proposal);
            }
            ++n2;
        }
        this.namesTracker.clear();
        this.counter = 1;
    }

    private Template buildUIGenerationTemplate(Template template, ContentAssistContext context) {
        EObject current = context.getCurrentModel();
        this.resourceSet = current.eResource().getResourceSet();
        String projectName = current.eResource().getURI().segment(1);
        URI primary = ResourceHelper.getPrimaryResourceURI((String)projectName);
        Resource primaryResource = ResourceHelper.loadResource((URI)primary, (ResourceSet)this.resourceSet);
        if (primaryResource == null) {
            throw new RuntimeException("could not locate primary resource with uri " + primary);
        }
        Viewpoint viewpoint = (Viewpoint)primaryResource.getContents().get(0);
        List dataResourceURIs = ResourceHelper.getSecondaryResourceURIsByExtension((String)"data.vptext", (String)projectName);
        block0: for (URI uri : dataResourceURIs) {
            List dataRoots = ResourceHelper.loadDataResource((URI)uri, (ResourceSet)this.resourceSet);
            if (dataRoots.isEmpty()) continue;
            for (EObject root : dataRoots) {
                if (!(root instanceof Data)) continue;
                Data data = (Data)root;
                TreeAppendable appendable = new TreeAppendable(current, "\t", "\n");
                EList vpClasses = data.getVP_Classes();
                for (Class candidate : vpClasses) {
                    if (candidate.isAbstract()) continue;
                    this.generateUIForCurrentClass(candidate, viewpoint, data.getName(), appendable);
                }
                template.setPattern(appendable.getContent());
                continue block0;
            }
        }
        return template;
    }

    private void generateUIForCurrentClass(Class containingClass, Viewpoint vp, String prefix, TreeAppendable appendable) {
        String className;
        Class ownedClass;
        HashSet<Object> processed;
        appendable.append((CharSequence)"UI ").append((CharSequence)vp.getShortName().replaceAll("\"", "")).append((CharSequence)"_").append((CharSequence)containingClass.getName()).append((CharSequence)" {");
        appendable.increaseIndentation().newLine();
        appendable.append((CharSequence)"label: \"").append((CharSequence)this.toLabel(vp.getShortName().replaceAll("\"", ""))).append((CharSequence)"\"");
        appendable.newLine();
        appendable.append((CharSequence)"Container ").append((CharSequence)vp.getShortName().replaceAll("\"", "")).append((CharSequence)"_").append((CharSequence)containingClass.getName()).append((CharSequence)"_Section").append((CharSequence)" {");
        appendable.increaseIndentation().newLine();
        if (this.hasAttributes(containingClass)) {
            appendable.append((CharSequence)"Container ").append((CharSequence)vp.getShortName().replaceAll("\"", "")).append((CharSequence)"_").append((CharSequence)containingClass.getName()).append((CharSequence)"_").append((CharSequence)"AttributeGroup").append((CharSequence)" {");
            appendable.increaseIndentation().newLine();
            appendable.append((CharSequence)"label: \"").append((CharSequence)this.toLabel(containingClass.getName())).append((CharSequence)" Attributes").append((CharSequence)"\"");
            List<Attribute> allAttributes = this.collectAllAttributes(containingClass);
            processed = new HashSet<Object>();
            for (Attribute attribute : allAttributes) {
                if (processed.contains(attribute)) continue;
                ownedClass = (Class)attribute.eContainer();
                className = this.getFQN(ownedClass.getName());
                if (attribute.getOwned_type() instanceof LocalAttributeType) {
                    Enumeration enumeration = ((LocalAttributeType)attribute.getOwned_type()).getType();
                    this.generateRadioBoxUIEnumeration(enumeration, attribute, className, prefix, appendable);
                    processed.add(attribute);
                    continue;
                }
                if (!(attribute.getOwned_type() instanceof ExternalAttributeType)) {
                    processed.add(attribute);
                    continue;
                }
                EDataType type = ResourceHelper.resolveDataType((EDataType)((ExternalAttributeType)attribute.getOwned_type()).getType(), (ResourceSet)this.resourceSet);
                String attributeName = attribute.getName();
                attributeName = this.getFQN(attributeName);
                if (type.getName().equals("EBoolean")) {
                    appendable.newLine().append((CharSequence)"Field ").append((CharSequence)attributeName).append((CharSequence)"Field");
                    this.appendCounterToField(appendable, attributeName);
                    appendable.append((CharSequence)" label: \"").append((CharSequence)this.toLabel(attribute.getName())).append((CharSequence)"\" type ").append((CharSequence)"checkbox").append((CharSequence)" , mapped-to ").append((CharSequence)prefix).append((CharSequence)".").append((CharSequence)className).append((CharSequence)".").append((CharSequence)attributeName);
                } else if (type.getName().equals("EEnumerator") || type instanceof EEnum) {
                    appendable.newLine().append((CharSequence)"Field ").append((CharSequence)attributeName).append((CharSequence)"Field");
                    this.appendCounterToField(appendable, attributeName);
                    appendable.append((CharSequence)" label: \"").append((CharSequence)this.toLabel(attribute.getName())).append((CharSequence)"\" type ").append((CharSequence)"radiobox").append((CharSequence)" , mapped-to ").append((CharSequence)prefix).append((CharSequence)".").append((CharSequence)className).append((CharSequence)".").append((CharSequence)attributeName);
                } else {
                    appendable.newLine().append((CharSequence)"Field ").append((CharSequence)attributeName).append((CharSequence)"Field");
                    this.appendCounterToField(appendable, attributeName);
                    appendable.append((CharSequence)" label: \"").append((CharSequence)this.toLabel(attribute.getName())).append((CharSequence)"\" type ").append((CharSequence)"text").append((CharSequence)" , mapped-to ").append((CharSequence)prefix).append((CharSequence)".").append((CharSequence)className).append((CharSequence)".").append((CharSequence)attributeName);
                }
                processed.add(attribute);
                this.namesTracker.add(attributeName);
            }
            appendable.decreaseIndentation().newLine();
            appendable.append((CharSequence)"}");
            processed.clear();
        }
        if (this.hasAssociations(containingClass)) {
            if (this.hasAttributes(containingClass)) {
                appendable.newLine();
            }
            appendable.append((CharSequence)"Container ").append((CharSequence)vp.getShortName().replaceAll("\"", "")).append((CharSequence)"_").append((CharSequence)containingClass.getName()).append((CharSequence)"_").append((CharSequence)"AssociationGroup").append((CharSequence)" {");
            appendable.increaseIndentation().newLine();
            appendable.append((CharSequence)"label: \"").append((CharSequence)this.toLabel(containingClass.getName())).append((CharSequence)" Associations").append((CharSequence)"\"");
            List<AbstractAssociation> allAssociations = this.collectAllAssociations(containingClass);
            processed = new HashSet();
            for (AbstractAssociation abs : allAssociations) {
                if (processed.contains(abs)) continue;
                ownedClass = (Class)abs.eContainer();
                className = this.getFQN(ownedClass.getName());
                String absName = abs.getName();
                String cardinality = abs.getCardinality().getName();
                if (cardinality.equals("One_Or_Many") || cardinality.equals("Nothing_Or_Many")) {
                    appendable.newLine().append((CharSequence)"Field ").append((CharSequence)absName).append((CharSequence)"Association");
                    this.appendCounterToField(appendable, absName);
                    appendable.append((CharSequence)" label: \"").append((CharSequence)this.toLabel(absName)).append((CharSequence)"\" type ").append((CharSequence)"multipleChoiceList").append((CharSequence)" , mapped-to ").append((CharSequence)prefix).append((CharSequence)".").append((CharSequence)className).append((CharSequence)".").append((CharSequence)absName);
                } else {
                    appendable.newLine().append((CharSequence)"Field ").append((CharSequence)absName).append((CharSequence)"Association");
                    this.appendCounterToField(appendable, absName);
                    appendable.append((CharSequence)" label: \"").append((CharSequence)this.toLabel(absName)).append((CharSequence)"\" type ").append((CharSequence)"simpleChoiceList").append((CharSequence)" , mapped-to ").append((CharSequence)prefix).append((CharSequence)".").append((CharSequence)className).append((CharSequence)".").append((CharSequence)absName);
                }
                processed.add(abs);
                this.namesTracker.add(absName);
            }
            appendable.decreaseIndentation().newLine();
            appendable.append((CharSequence)"}");
            processed.clear();
        }
        appendable.decreaseIndentation().newLine();
        appendable.append((CharSequence)"}");
        appendable.decreaseIndentation().newLine();
        appendable.append((CharSequence)"}").newLine();
    }

    private String getFQN(String className) {
        try {
            className = this.valueConverter.toString((Object)className, "FQN");
        }
        catch (ValueConverterException e) {
            Status status = new Status(4, "org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Vpui", e.getMessage(), (Throwable)e);
            VpuiActivator.getInstance().getLog().log((IStatus)status);
        }
        return className;
    }

    private void generateRadioBoxUIEnumeration(Enumeration enumeration, Attribute attribute, String className, String prefix, TreeAppendable appendable) {
        String attributeName = attribute.getName();
        attributeName = this.getFQN(attributeName);
        appendable.newLine().append((CharSequence)"Field ").append((CharSequence)attributeName).append((CharSequence)"Field");
        this.appendCounterToField(appendable, attributeName);
        appendable.append((CharSequence)" label: \"").append((CharSequence)this.toLabel(enumeration.getName())).append((CharSequence)"\" type ").append((CharSequence)"radiobox").append((CharSequence)" , mapped-to ").append((CharSequence)prefix).append((CharSequence)".").append((CharSequence)className).append((CharSequence)".").append((CharSequence)attributeName);
        this.namesTracker.add(attributeName);
    }

    private boolean hasAttributes(Class clazz) {
        for (AbstractSuperClass superClass : clazz.getInheritences()) {
            if (!(superClass instanceof LocalSuperClass)) continue;
            return this.hasAttributes(((LocalSuperClass)superClass).getSuperClass());
        }
        return !clazz.getVP_Class_Attributes().isEmpty();
    }

    private boolean hasAssociations(Class clazz) {
        for (AbstractSuperClass superClass : clazz.getInheritences()) {
            if (!(superClass instanceof LocalSuperClass)) continue;
            return this.hasAssociations(((LocalSuperClass)superClass).getSuperClass());
        }
        return !clazz.getVP_Classes_Associations().isEmpty();
    }

    private List<Attribute> collectAllAttributes(Class clazz) {
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        for (AbstractSuperClass superClass : clazz.getInheritences()) {
            if (!(superClass instanceof LocalSuperClass)) continue;
            Class superClazz = ((LocalSuperClass)superClass).getSuperClass();
            result.addAll((Collection<Attribute>)superClazz.getVP_Class_Attributes());
            result.addAll(this.collectAllAttributes(superClazz));
        }
        result.addAll((Collection<Attribute>)clazz.getVP_Class_Attributes());
        return result;
    }

    private List<AbstractAssociation> collectAllAssociations(Class clazz) {
        ArrayList<AbstractAssociation> result = new ArrayList<AbstractAssociation>();
        for (AbstractSuperClass superClass : clazz.getInheritences()) {
            if (!(superClass instanceof LocalSuperClass)) continue;
            Class superClazz = ((LocalSuperClass)superClass).getSuperClass();
            result.addAll((Collection<AbstractAssociation>)superClazz.getVP_Classes_Associations());
            result.addAll(this.collectAllAssociations(superClazz));
        }
        result.addAll((Collection<AbstractAssociation>)clazz.getVP_Classes_Associations());
        return result;
    }

    private TreeAppendable appendCounterToField(TreeAppendable appendable, String name) {
        if (this.namesTracker.contains(name)) {
            appendable.append((CharSequence)String.valueOf(this.counter));
            ++this.counter;
        }
        return appendable;
    }
}

