/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.ecore.helpers;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.polarsys.kitalpha.doc.gen.business.ecore.helpers.EcoreFileNameService;

public class EcoreModelHelper {
    private static final String EANNOTATION_SRC = "http://www.polarsys.org/kitalpha/ecore/documentation";

    public static String getDescription(EModelElement modelElement) {
        String description;
        String descriptionValue = "";
        EAnnotation annotation = modelElement.getEAnnotation(EANNOTATION_SRC);
        if (annotation != null && (description = (String)annotation.getDetails().get((Object)"description")) != null && !description.equalsIgnoreCase("null")) {
            descriptionValue = description;
        }
        descriptionValue = descriptionValue.replaceAll("\n", "<br />");
        return descriptionValue;
    }

    public static String getUsageExamples(EModelElement modelElement) {
        return EcoreModelHelper.getEAnnotationHtmlValue(modelElement, "usage examples");
    }

    public static String getUsedInLevels(EModelElement modelElement) {
        return EcoreModelHelper.getEAnnotationHtmlValue(modelElement, "used in levels");
    }

    public static String getConstraints(EModelElement modelElement) {
        return EcoreModelHelper.getEAnnotationHtmlValue(modelElement, "constraints");
    }

    public static String getUsageGuideline(EModelElement modelElement) {
        return EcoreModelHelper.getEAnnotationHtmlValue(modelElement, "usage guideline");
    }

    private static String getEAnnotationHtmlValue(EModelElement modelElement, String key) {
        String keyValue;
        String value = "";
        EAnnotation annotation = modelElement.getEAnnotation(EANNOTATION_SRC);
        if (annotation != null && (keyValue = (String)annotation.getDetails().get((Object)key)) != null) {
            if (key.equals("usage examples") && !keyValue.equals("n/a") && !keyValue.equals("none")) {
                keyValue = "<img src=\"" + keyValue + "\" alt=\"example\" />";
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append("<p><strong>" + key.substring(0, 1).toUpperCase() + key.substring(1) + ":</strong><br />");
            buffer.append(keyValue);
            buffer.append("</p>");
            return buffer.toString();
        }
        return value;
    }

    public static String getTypeHyperLink(ENamedElement element) {
        return EcoreModelHelper.getTypeHyperLink(element, null);
    }

    public static String getTypeHyperLink(ENamedElement element, String content) {
        EObject root;
        String modelName = "";
        if (element.eResource() != null && (root = (EObject)element.eResource().getContents().get(0)) instanceof EPackage) {
            modelName = ((EPackage)root).getName();
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("<a href=\"");
        if (modelName != "") {
            buffer.append("../" + modelName + "/");
        }
        buffer.append(EcoreFileNameService.INSTANCE.getFileName((EObject)element));
        buffer.append(".html\">");
        if (content != null) {
            buffer.append(content);
        } else {
            buffer.append(element.getName());
        }
        buffer.append("</a>");
        return buffer.toString();
    }
}

