/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.resourcereuse.emfscheme.ui;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.ui.handlers.HandlerUtil;
import org.polarsys.kitalpha.resourcereuse.emfscheme.helpers.ModelReuseHelper;
import org.polarsys.kitalpha.resourcereuse.emfscheme.utils.services.ResourceSetLoaderServices;
import org.polarsys.kitalpha.resourcereuse.model.SearchCriteria;
import org.polarsys.kitalpha.resourcereuse.ui.dialog.ResourceReuseSelectionDialog;

public class LoadResourceReuseHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            ResourceReuseSelectionDialog dialog;
            EList contents;
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object firstElement = structuredSelection.getFirstElement();
            if (firstElement instanceof GraphicalEditPart) {
                firstElement = ((GraphicalEditPart)firstElement).resolveSemanticElement();
            }
            if (firstElement instanceof Resource && !(contents = ((Resource)firstElement).getContents()).isEmpty()) {
                firstElement = contents.get(0);
            }
            if (firstElement instanceof EObject && (dialog = new ResourceReuseSelectionDialog(HandlerUtil.getActiveShell((ExecutionEvent)event))).open() == 0) {
                EObject eObject = (EObject)firstElement;
                final Session session = SessionManager.INSTANCE.getExistingSession(eObject.eResource().getURI());
                SearchCriteria criteria = dialog.getCriteria();
                final URI modelToLoad = ModelReuseHelper.createModelReuseURI((SearchCriteria)criteria);
                ResourceSetLoaderServices.loadResourceForCurrentResourceSet((EObject)eObject, (URI)modelToLoad);
                if (session != null) {
                    RecordingCommand command = new RecordingCommand(session.getTransactionalEditingDomain()){

                        protected void doExecute() {
                            session.addSemanticResource(modelToLoad, (IProgressMonitor)new NullProgressMonitor());
                        }
                    };
                    session.getTransactionalEditingDomain().getCommandStack().execute((Command)command);
                }
            }
        }
        return null;
    }
}

