/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.accuracy.ui.internal.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.polarsys.kitalpha.accuracy.ui.AccuracyUIMessages;
import org.polarsys.kitalpha.accuracy.ui.AccuracyUIPlugin;
import org.polarsys.kitalpha.validation.configurer.ConfigurerException;
import org.polarsys.kitalpha.validation.configurer.IConstraintConfigurer;

public class ApplyConfigurationHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IFile selectedProperties = this.getSelectedFile(HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (selectedProperties != null) {
            Properties properties = new Properties();
            try {
                InputStream in = selectedProperties.getContents();
                try {
                    try {
                        properties.load(in);
                    }
                    catch (IOException e) {
                        this.popupProblem(e, shell);
                        throw new ExecutionException(e.getMessage(), (Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            catch (CoreException e) {
                this.popupProblem((Exception)((Object)e), shell);
                throw new ExecutionException(e.getMessage(), (Throwable)e);
            }
            try {
                IConstraintConfigurer.INSTANCE.configure(properties);
            }
            catch (ConfigurerException e) {
                this.popupProblem((Exception)((Object)e), shell);
                throw new ExecutionException(e.getMessage(), (Throwable)e);
            }
            this.popupSuccess(shell);
        }
        return null;
    }

    private void popupProblem(Exception e, Shell shell) {
        MessageDialog.openError((Shell)shell, (String)AccuracyUIMessages.getString("accuracy.error.applyingconfiguration"), (String)e.getMessage());
        Status status = new Status(4, "org.polarsys.kitalpha.accuracy.ui", AccuracyUIMessages.getString("accuracy.error.applyingconfiguration"), (Throwable)e);
        AccuracyUIPlugin.getDefault().getLog().log((IStatus)status);
    }

    private void popupSuccess(Shell shell) {
        MessageDialog.openInformation((Shell)shell, (String)AccuracyUIMessages.getString("accuracy.configurationapplied.title"), (String)AccuracyUIMessages.getString("accuracy.configurationapplied.message"));
    }

    private IFile getSelectedFile(ISelection currentSelection) {
        if (currentSelection instanceof StructuredSelection) {
            Object o = ((StructuredSelection)currentSelection).getFirstElement();
            if (o instanceof IFile) {
                return (IFile)o;
            }
            if (o instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)o;
                Object adapted = adaptable.getAdapter(IFile.class);
                if (adapted instanceof IFile) {
                    return (IFile)adaptable;
                }
                adapted = Platform.getAdapterManager().getAdapter(o, IFile.class);
                if (adapted instanceof IFile) {
                    return (IFile)adapted;
                }
            }
        }
        return null;
    }
}

