/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.helper.egf;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egf.core.domain.TargetPlatformResourceSet;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.core.producer.MissingExtensionException;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.producer.EGFProducerPlugin;
import org.eclipse.egf.producer.manager.ActivityManagerProducer;
import org.eclipse.egf.producer.manager.IActivityManager;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;

public class InvokeActivityHelper {
    private static EditingDomain editingDomain;

    public static boolean validateAndInvoke(Activity activity, String generationName) {
        Diagnostic diagnostic = Diagnostician.INSTANCE.validate((EObject)activity);
        if (diagnostic.getSeverity() != 4) {
            try {
                InvokeActivityHelper.invoke(activity, generationName);
                return true;
            }
            catch (MissingExtensionException e) {
                e.printStackTrace();
            }
            catch (InvocationException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static void invoke(Activity activity, String generationName) throws MissingExtensionException, InvocationException, CoreException {
        ActivityManagerProducer producer = EGFProducerPlugin.getActivityManagerProducer((Activity)activity);
        final IActivityManager activityManager = producer.createActivityManager(activity);
        activityManager.initializeContext();
        Job job = new Job("Viewpoint generation"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    activityManager.invoke(monitor);
                    activityManager.dispose();
                }
                catch (InvocationException e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public static Activity getActivity(URI activityURI) {
        EditingDomain editingDomain = InvokeActivityHelper.getEditingDomain();
        ResourceSet rs = editingDomain.getResourceSet();
        return (Activity)rs.getEObject(activityURI, true);
    }

    private static EditingDomain getEditingDomain() {
        if (editingDomain == null) {
            return InvokeActivityHelper.initializeEditingDomain();
        }
        return editingDomain;
    }

    private static EditingDomain initializeEditingDomain() {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        BasicCommandStack statck = new BasicCommandStack();
        TargetPlatformResourceSet resourceSet = new TargetPlatformResourceSet();
        return new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)statck, (ResourceSet)resourceSet);
    }
}

