/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.helpers.vpdiagram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.ContentHelper;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.style.ContainerStyleDescription;
import org.eclipse.sirius.diagram.description.style.HideLabelCapabilityStyleDescription;
import org.eclipse.sirius.viewpoint.description.ColorDescription;
import org.eclipse.sirius.viewpoint.description.ConditionalStyleDescription;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.SytemColorsPalette;
import org.eclipse.sirius.viewpoint.description.UserColor;
import org.eclipse.sirius.viewpoint.description.UserColorsPalette;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.style.BasicLabelStyleDescription;
import org.eclipse.sirius.viewpoint.description.style.StyleDescription;
import org.eclipse.sirius.viewpoint.description.style.TooltipStyleDescription;

public class SiriusViewpointHelper {
    public static Viewpoint getRootviewpoint(Resource resource) {
        EObject eObject;
        EList contents = resource.getContents();
        if (contents != null && !contents.isEmpty() && (eObject = (EObject)contents.get(0)) instanceof Group) {
            return (Viewpoint)((Group)eObject).getOwnedViewpoints().get(0);
        }
        return null;
    }

    public static Group getViewpointGroup(Resource resource) {
        TreeIterator it = resource.getAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (!(obj instanceof Group)) continue;
            return (Group)obj;
        }
        return null;
    }

    public static List<RepresentationDescription> getAllRepresentationDescription(Resource resource) {
        Viewpoint v = SiriusViewpointHelper.getRootviewpoint(resource);
        if (v != null) {
            return Collections.unmodifiableList(v.getOwnedRepresentations());
        }
        return null;
    }

    public static List<ContainerMapping> getAllContainerMapping(Resource resource) {
        ArrayList<ContainerMapping> result = new ArrayList<ContainerMapping>();
        Viewpoint v = SiriusViewpointHelper.getRootviewpoint(resource);
        if (v != null) {
            EList desc = v.getOwnedRepresentations();
            for (RepresentationDescription rd : desc) {
                if (!(rd instanceof DiagramDescription)) continue;
                DiagramDescription dd = (DiagramDescription)rd;
                result.addAll((Collection<ContainerMapping>)ContentHelper.getAllContainerMappings((DiagramDescription)dd, (boolean)true));
                for (ContainerMapping cm : ContentHelper.getAllContainerMappings((DiagramDescription)dd, (boolean)true)) {
                    List<ContainerMapping> subResult = SiriusViewpointHelper.getSubContainers(cm);
                    if (subResult == null || subResult.isEmpty()) continue;
                    result.addAll(subResult);
                }
            }
        }
        return result;
    }

    public static List<ContainerMapping> getAllContainerMapping(List<DiagramDescription> diagrams) {
        ArrayList<ContainerMapping> result = new ArrayList<ContainerMapping>();
        for (DiagramDescription dd : diagrams) {
            result.addAll((Collection<ContainerMapping>)ContentHelper.getAllContainerMappings((DiagramDescription)dd, (boolean)true));
            for (ContainerMapping cm : ContentHelper.getAllContainerMappings((DiagramDescription)dd, (boolean)true)) {
                List<ContainerMapping> subResult = SiriusViewpointHelper.getSubContainers(cm);
                if (subResult == null || subResult.isEmpty()) continue;
                result.addAll(subResult);
            }
        }
        return result;
    }

    public static List<ContainerMapping> getSubContainers(ContainerMapping container) {
        ArrayList<ContainerMapping> result = new ArrayList<ContainerMapping>();
        for (ContainerMapping containerMapping : container.getSubContainerMappings()) {
            List<ContainerMapping> subResult;
            if (!result.contains(containerMapping)) {
                result.add(containerMapping);
            }
            if ((subResult = SiriusViewpointHelper.getSubContainers(containerMapping)) == null || subResult.size() <= 0) continue;
            for (ContainerMapping containerMapping2 : subResult) {
                if (result.contains(containerMapping2)) continue;
                result.add(containerMapping2);
            }
        }
        return result;
    }

    public static List<DiagramDescription> getAllDiagramDescription(Resource resource) {
        ArrayList<DiagramDescription> diagramDescriptions = new ArrayList<DiagramDescription>();
        List<RepresentationDescription> desc = SiriusViewpointHelper.getAllRepresentationDescription(resource);
        if (desc != null && !desc.isEmpty()) {
            for (RepresentationDescription rd : desc) {
                if (!(rd instanceof DiagramDescription)) continue;
                DiagramDescription dd = (DiagramDescription)rd;
                diagramDescriptions.add(dd);
            }
        }
        return diagramDescriptions;
    }

    public static List<NodeMapping> getAllNodeMapping(Resource resource) {
        ArrayList<NodeMapping> result = new ArrayList<NodeMapping>();
        List<DiagramDescription> desc = SiriusViewpointHelper.getAllDiagramDescription(resource);
        if (desc != null && !desc.isEmpty()) {
            for (DiagramDescription dd : desc) {
                result.addAll((Collection<NodeMapping>)ContentHelper.getAllNodeMappings((DiagramDescription)dd, (boolean)true));
                for (NodeMapping nm : ContentHelper.getAllNodeMappings((DiagramDescription)dd, (boolean)true)) {
                    List<NodeMapping> borderedNodes = SiriusViewpointHelper.getBorderedNodes(nm);
                    if (borderedNodes == null || borderedNodes.size() <= 0) continue;
                    for (NodeMapping nodeMapping : borderedNodes) {
                        if (result.contains(nodeMapping)) continue;
                        result.add(nodeMapping);
                    }
                }
                for (ContainerMapping iContainerMapping : ContentHelper.getAllContainerMappings((DiagramDescription)dd, (boolean)true)) {
                    List<NodeMapping> subNodes = SiriusViewpointHelper.getSubNodes(iContainerMapping);
                    if (subNodes == null || subNodes.size() <= 0) continue;
                    result.addAll(subNodes);
                }
            }
        }
        return result;
    }

    public static List<NodeMapping> getAllNodeMapping(List<DiagramDescription> diagrams) {
        ArrayList<NodeMapping> result = new ArrayList<NodeMapping>();
        if (diagrams != null && !diagrams.isEmpty()) {
            for (DiagramDescription dd : diagrams) {
                result.addAll((Collection<NodeMapping>)ContentHelper.getAllNodeMappings((DiagramDescription)dd, (boolean)true));
                for (NodeMapping nm : ContentHelper.getAllNodeMappings((DiagramDescription)dd, (boolean)true)) {
                    List<NodeMapping> borderedNodes = SiriusViewpointHelper.getBorderedNodes(nm);
                    if (borderedNodes == null || borderedNodes.size() <= 0) continue;
                    for (NodeMapping nodeMapping : borderedNodes) {
                        if (result.contains(nodeMapping)) continue;
                        result.add(nodeMapping);
                    }
                }
                for (ContainerMapping iContainerMapping : ContentHelper.getAllContainerMappings((DiagramDescription)dd, (boolean)true)) {
                    List<NodeMapping> subNodes = SiriusViewpointHelper.getSubNodes(iContainerMapping);
                    if (subNodes == null || subNodes.size() <= 0) continue;
                    result.addAll(subNodes);
                }
            }
        }
        return result;
    }

    public static List<NodeMapping> getSubNodes(ContainerMapping container) {
        BasicEList result = new BasicEList();
        for (NodeMapping subNodeMapping : container.getSubNodeMappings()) {
            List<NodeMapping> nodeBorderedNodes;
            if (!result.contains(subNodeMapping)) {
                result.add(subNodeMapping);
            }
            if ((nodeBorderedNodes = SiriusViewpointHelper.getBorderedNodes(subNodeMapping)) == null || nodeBorderedNodes.size() <= 0) continue;
            for (NodeMapping nodeMapping : nodeBorderedNodes) {
                if (result.contains(nodeMapping)) continue;
                result.add(nodeMapping);
            }
        }
        for (NodeMapping borderedNodeMapping : container.getBorderedNodeMappings()) {
            if (result.contains(borderedNodeMapping)) continue;
            result.add(borderedNodeMapping);
        }
        for (ContainerMapping iContainerMapping : container.getSubContainerMappings()) {
            List<NodeMapping> subContainerSubNodes = SiriusViewpointHelper.getSubNodes(iContainerMapping);
            if (subContainerSubNodes == null || subContainerSubNodes.size() <= 0) continue;
            for (NodeMapping nodeMapping : subContainerSubNodes) {
                if (result.contains(nodeMapping)) continue;
                result.add(nodeMapping);
            }
        }
        return result;
    }

    public static List<NodeMapping> getBorderedNodes(NodeMapping node) {
        BasicEList result = new BasicEList();
        for (NodeMapping borderedNodeMapping : node.getBorderedNodeMappings()) {
            if (result.contains(borderedNodeMapping)) continue;
            result.add(borderedNodeMapping);
        }
        return result;
    }

    public static List<EdgeMapping> getAllEdgeMapping(Resource resource) {
        ArrayList<EdgeMapping> result = new ArrayList<EdgeMapping>();
        List<DiagramDescription> diagrams = SiriusViewpointHelper.getAllDiagramDescription(resource);
        for (DiagramDescription iDiagram : diagrams) {
            result.addAll((Collection<EdgeMapping>)iDiagram.getAllEdgeMappings());
        }
        return result;
    }

    public static List<EdgeMapping> getAllEdgeMapping(List<DiagramDescription> diagrams) {
        ArrayList<EdgeMapping> result = new ArrayList<EdgeMapping>();
        if (diagrams != null && !diagrams.isEmpty()) {
            for (DiagramDescription iDiagram : diagrams) {
                result.addAll((Collection<EdgeMapping>)iDiagram.getAllEdgeMappings());
            }
        }
        return result;
    }

    public static List<StyleDescription> getAllStyleDescriptionFromEdgeMappings(List<EdgeMapping> edgeMappings) {
        ArrayList<StyleDescription> result = new ArrayList<StyleDescription>();
        if (edgeMappings != null && !edgeMappings.isEmpty()) {
            for (EdgeMapping edge : edgeMappings) {
                result.add((StyleDescription)edge.getStyle());
            }
        }
        return result;
    }

    public static List<ConditionalStyleDescription> getAllConditionalStyleDescriptionFromMappings(List<EdgeMapping> edgeMappings) {
        ArrayList<ConditionalStyleDescription> result = new ArrayList<ConditionalStyleDescription>();
        if (edgeMappings != null && !edgeMappings.isEmpty()) {
            for (EdgeMapping edge : edgeMappings) {
                result.addAll((Collection<ConditionalStyleDescription>)edge.getConditionnalStyles());
            }
        }
        return result;
    }

    public static List<StyleDescription> getAllStyleDescription(List<DiagramDescription> diagrams) {
        ArrayList<StyleDescription> result = new ArrayList<StyleDescription>();
        for (DiagramDescription diagramDescription : diagrams) {
            SiriusViewpointHelper.findAllStyleDescriptions(diagramDescription, result);
        }
        return result;
    }

    private static void findAllStyleDescriptions(DiagramDescription diagramDescription, List<StyleDescription> result) {
        TreeIterator eAllContents = diagramDescription.eAllContents();
        while (eAllContents.hasNext()) {
            EObject next = (EObject)eAllContents.next();
            if (!(next instanceof StyleDescription)) continue;
            result.add((StyleDescription)next);
        }
    }

    public static List<BasicLabelStyleDescription> getAllBasicLabelDescription(List<DiagramDescription> diagrams) {
        ArrayList<BasicLabelStyleDescription> result = new ArrayList<BasicLabelStyleDescription>();
        for (DiagramDescription diagramDescription : diagrams) {
            SiriusViewpointHelper.findAllBasicLabelDescription(diagramDescription, result);
        }
        return result;
    }

    private static void findAllBasicLabelDescription(DiagramDescription diagramDescription, List<BasicLabelStyleDescription> result) {
        TreeIterator eAllContents = diagramDescription.eAllContents();
        while (eAllContents.hasNext()) {
            EObject next = (EObject)eAllContents.next();
            if (!(next instanceof BasicLabelStyleDescription)) continue;
            result.add((BasicLabelStyleDescription)next);
        }
    }

    public static List<TooltipStyleDescription> getAllToolTipStyleDescription(List<DiagramDescription> diagrams) {
        ArrayList<TooltipStyleDescription> result = new ArrayList<TooltipStyleDescription>();
        for (DiagramDescription diagramDescription : diagrams) {
            SiriusViewpointHelper.findAllToolTipStyleDescription(diagramDescription, result);
        }
        return result;
    }

    private static void findAllToolTipStyleDescription(DiagramDescription diagramDescription, List<TooltipStyleDescription> result) {
        TreeIterator eAllContents = diagramDescription.eAllContents();
        while (eAllContents.hasNext()) {
            EObject next = (EObject)eAllContents.next();
            if (!(next instanceof TooltipStyleDescription)) continue;
            result.add((TooltipStyleDescription)next);
        }
    }

    public static List<HideLabelCapabilityStyleDescription> getAllHideLabelCapabilityStyleDescription(List<DiagramDescription> diagrams) {
        ArrayList<HideLabelCapabilityStyleDescription> result = new ArrayList<HideLabelCapabilityStyleDescription>();
        for (DiagramDescription diagramDescription : diagrams) {
            SiriusViewpointHelper.findAllHideLabelCapabilityStyleDescription(diagramDescription, result);
        }
        return result;
    }

    private static void findAllHideLabelCapabilityStyleDescription(DiagramDescription diagramDescription, List<HideLabelCapabilityStyleDescription> result) {
        TreeIterator eAllContents = diagramDescription.eAllContents();
        while (eAllContents.hasNext()) {
            EObject next = (EObject)eAllContents.next();
            if (!(next instanceof HideLabelCapabilityStyleDescription)) continue;
            result.add((HideLabelCapabilityStyleDescription)next);
        }
    }

    public static List<UserColor> getAllUserColor(Resource resource) {
        ArrayList<UserColor> result = new ArrayList<UserColor>();
        Group group = SiriusViewpointHelper.getGroup(resource);
        SiriusViewpointHelper.findAllUserColor(group, result);
        return result;
    }

    private static void findAllUserColor(Group group, List<UserColor> result) {
        if (group != null) {
            EList userColorsPalettes = group.getUserColorsPalettes();
            for (UserColorsPalette userColorsPalette : userColorsPalettes) {
                EList entries = userColorsPalette.getEntries();
                result.addAll((Collection<UserColor>)entries);
            }
        }
    }

    public static List<ColorDescription> getAllSystemColor(Resource resource) {
        ArrayList<ColorDescription> result = new ArrayList<ColorDescription>();
        Group group = SiriusViewpointHelper.getGroup(resource);
        SiriusViewpointHelper.findAllColorDescription(group, result);
        return result;
    }

    private static Group getGroup(Resource resource) {
        EObject eObject;
        EList contents = resource.getContents();
        if (contents != null && !contents.isEmpty() && (eObject = (EObject)contents.get(0)) instanceof Group) {
            return (Group)eObject;
        }
        return null;
    }

    private static void findAllColorDescription(Group group, List<ColorDescription> result) {
        if (group != null) {
            SiriusViewpointHelper.findAllSystemColors(group, result);
        }
    }

    private static void findAllSystemColors(Group group, List<ColorDescription> result) {
        SytemColorsPalette systemColorsPalette = group.getSystemColorsPalette();
        EList entries = systemColorsPalette.getEntries();
        result.addAll((Collection<ColorDescription>)entries);
    }

    public static List<ContainerStyleDescription> getAllContainerStyleDescription(List<DiagramDescription> diagrams) {
        ArrayList<ContainerStyleDescription> result = new ArrayList<ContainerStyleDescription>();
        for (DiagramDescription diagramDescription : diagrams) {
            SiriusViewpointHelper.findAllContainerStyleDescription(diagramDescription, result);
        }
        return result;
    }

    private static void findAllContainerStyleDescription(DiagramDescription diagramDescription, List<ContainerStyleDescription> result) {
        TreeIterator eAllContents = diagramDescription.eAllContents();
        while (eAllContents.hasNext()) {
            EObject next = (EObject)eAllContents.next();
            if (!(next instanceof ColorDescription)) continue;
            result.add((ContainerStyleDescription)next);
        }
    }
}

