/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.transposer.transformation.emf.activities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.kitalpha.cadence.core.api.IActivity;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.cadence.core.api.parameter.DeclaredParameter;
import org.polarsys.kitalpha.cadence.core.api.parameter.ParameterError;
import org.polarsys.kitalpha.transposer.TransposerCorePlugin;
import org.polarsys.kitalpha.transposer.api.ITransposerWorkflow;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;
import org.polarsys.kitalpha.transposer.transformation.context.GenericTransformationContext;
import org.polarsys.kitalpha.transposer.transformation.emf.util.EcoreIdentifierUtil;
import org.polarsys.kitalpha.transposer.transformation.trace.Trace;
import org.polarsys.kitalpha.transposer.transformation.trace.TraceHelper;

public class TraceCleaner
implements IActivity,
ITransposerWorkflow {
    public static final String ID = "org.polarsys.kitalpha.transposer.transformation.emf.trace.clean";
    public static final String TRANSFORMATION_FIRST_METACLASSES = "transposer.transformation.first.metaclasses";
    private TraceHelper _traceHelper = null;
    private Set<?> _transformableElements = null;
    private Set<EClass> _firstMetaClasses = Collections.emptySet();
    private Collection<EObject> _cleanedElements = new HashSet<EObject>();

    public Collection<DeclaredParameter> getParameters() {
        return null;
    }

    public IStatus run(ActivityParameters activityParams_p) {
        Object set;
        IContext context = (IContext)activityParams_p.getParameter("TransposerContext").getValue();
        this._transformableElements = (Set)activityParams_p.getParameter("TransposerTransposableObjects").getValue();
        if (context == null) {
            return new Status(4, "org.polarsys.kitalpha.transposer.transformation.emf", "Context in not initialized in the Transposer Workflow");
        }
        if (context instanceof GenericTransformationContext) {
            this._traceHelper = ((GenericTransformationContext)context).getTraceHelper();
        }
        if (context.exists((Object)TRANSFORMATION_FIRST_METACLASSES)) {
            this._firstMetaClasses = (Set)context.get((Object)TRANSFORMATION_FIRST_METACLASSES);
        }
        ResourceSet rs = null;
        if (context.get((Object)"TransposerResourceSet") != null && (set = context.get((Object)"TransposerResourceSet")) instanceof ResourceSet) {
            rs = (ResourceSet)set;
        }
        Object entryPoint = null;
        if (context.exists((Object)"transposer.transformation.emf.entrypoint") && this._transformableElements != null) {
            entryPoint = context.get((Object)"transposer.transformation.emf.entrypoint");
        }
        if (this._traceHelper != null && this._transformableElements != null) {
            if (entryPoint instanceof Collection) {
                for (Object obj : (Collection)entryPoint) {
                    if (!(obj instanceof EObject) || rs != null) continue;
                    this.clean((EObject)obj);
                }
            } else if (entryPoint instanceof EObject && rs == null) {
                this.clean((EObject)entryPoint);
            }
        }
        if (this._cleanedElements.size() != 0) {
            this.logInfoCleanMessage();
        }
        return Status.OK_STATUS;
    }

    private void logInfoCleanMessage() {
        StringBuilder message = new StringBuilder();
        message.append(" WARNING \n");
        message.append("--- TraceCleaner cleaned elements ---\n");
        for (EObject obj : this._cleanedElements) {
            message.append(" . " + EcoreIdentifierUtil.getIdentifier((ENamedElement)obj.eClass()) + " : " + obj + "\n");
        }
        TransposerCorePlugin.getDefault().logInfo("org.polarsys.kitalpha.transposer.transformation.emf", message.toString(), null);
    }

    public Map<String, ParameterError<?>> validateParameters(ActivityParameters valuedParameters_p) {
        return null;
    }

    private void clean(EObject obj_p) {
        ArrayList listContents = new ArrayList(obj_p.eContents());
        for (EObject obj : listContents) {
            this.cleanTraces(obj);
            if (this.hasToBeRemoved(obj)) {
                this.removeCompletely(obj);
                continue;
            }
            this.clean(obj);
        }
    }

    private void cleanTraces(EObject eObject_p) {
        List incomingTraces = this._traceHelper.getIncomingTraces((Object)eObject_p);
        for (Trace trace : incomingTraces) {
            Object traceSource = trace.getSource();
            if (traceSource == null || traceSource instanceof EObject && ((EObject)traceSource).eResource() == null) {
                this._traceHelper.removeTrace(trace);
                continue;
            }
            if (this._transformableElements.contains(traceSource)) continue;
            this._traceHelper.removeTrace(trace);
        }
    }

    private boolean hasToBeRemoved(EObject eObject_p) {
        if (!this._firstMetaClasses.contains(eObject_p.eClass())) {
            return false;
        }
        return this.isOrphan(eObject_p);
    }

    private boolean isOrphan(EObject object_p) {
        return this._traceHelper.getIncomingTraces((Object)object_p).isEmpty();
    }

    private void removeCompletely(EObject eObject_p) {
        this._cleanedElements.add(eObject_p);
        this._traceHelper.removeAllIncomingTraces((Object)eObject_p);
        EcoreUtil.delete((EObject)eObject_p);
    }
}

