/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.richtext.widget.internal;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.polarsys.kitalpha.richtext.widget.editor.MDERichTextEditor;
import org.polarsys.kitalpha.richtext.widget.editor.MDERichTextEditorInput;
import org.polarsys.kitalpha.richtext.widget.helper.MDERichtextWidgetHelper;

public class RichtextEditorResourceSetListener
extends ResourceSetListenerImpl
implements ResourceSetListener {
    public void resourceSetChanged(ResourceSetChangeEvent event) {
        super.resourceSetChanged(event);
        List notifications = event.getNotifications();
        if (notifications.stream().anyMatch(notification -> notification.getEventType() == 4 || notification.getEventType() == 6)) {
            MDERichtextWidgetHelper.getActiveMDERichTextEditors().stream().forEach(editor -> this.handleClosingEditors((MDERichTextEditor)editor, event.getEditingDomain()));
        }
        notifications.stream().filter(notification -> notification.getEventType() == 1).forEach(this::updateEditorsTitle);
    }

    public NotificationFilter getFilter() {
        return NotificationFilter.createEventTypeFilter((int)4).or(NotificationFilter.createEventTypeFilter((int)6)).or(NotificationFilter.createEventTypeFilter((int)1));
    }

    public boolean isPostcommitOnly() {
        return true;
    }

    private void close(MDERichTextEditor richtextEditor) {
        if (richtextEditor != null) {
            Display.getDefault().asyncExec(() -> {
                boolean bl = richtextEditor.getEditorSite().getPage().closeEditor((IEditorPart)richtextEditor, false);
            });
        }
    }

    private void handleClosingEditors(MDERichTextEditor richtextEditor, TransactionalEditingDomain editingDomain) {
        MDERichTextEditorInput editorInput = (MDERichTextEditorInput)richtextEditor.getEditorInput();
        EObject element = editorInput.getElement();
        TransactionalEditingDomain eltEditingDomain = TransactionUtil.getEditingDomain((EObject)element);
        if ((eltEditingDomain == null || eltEditingDomain == editingDomain) && element.eResource() == null) {
            this.close(richtextEditor);
        }
    }

    private List<EStructuralFeature> getContributedTitleChangingFeatures() {
        return MDERichtextWidgetHelper.getInstance().getEditorInputFeatureContribution().stream().flatMap(contribution -> contribution.getTitleChangingFeatures().stream()).collect(Collectors.toList());
    }

    private void updateEditorsTitle(Notification notification) {
        if (this.getContributedTitleChangingFeatures().contains(notification.getFeature())) {
            for (MDERichTextEditor richtextEditor : MDERichtextWidgetHelper.getActiveMDERichTextEditors()) {
                MDERichTextEditorInput input = (MDERichTextEditorInput)richtextEditor.getEditorInput();
                EObject element = input.getElement();
                if (element != notification.getNotifier()) continue;
                richtextEditor.setMDERichTextEditorPartName();
            }
        }
    }
}

