/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.desc.ext.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.RefreshIdsHolder;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.query.EdgeMappingQuery;
import org.eclipse.sirius.diagram.business.internal.componentization.mappings.DiagramMappingsManagerRegistryImpl;
import org.eclipse.sirius.diagram.business.internal.metamodel.operations.DDiagramSpecOperations;
import org.eclipse.sirius.diagram.business.internal.sync.DDiagramElementSynchronizer;
import org.eclipse.sirius.diagram.business.internal.sync.DDiagramSynchronizer;
import org.eclipse.sirius.diagram.business.internal.sync.DEdgeCandidate;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class CreateEdgeCommand
extends RecordingCommand {
    private DDiagram _diagram;
    private Session _session;
    private EdgeMapping _mapping;
    private EObject _target;
    private boolean _isElementBasedEdge;

    public CreateEdgeCommand(Session session, DDiagram diagram, EdgeMapping mapping, EObject target, boolean isElementBasedEdge) {
        this(session.getTransactionalEditingDomain());
        this._diagram = diagram;
        this._session = session;
        this._mapping = mapping;
        this._target = target;
        this._isElementBasedEdge = isElementBasedEdge;
    }

    private CreateEdgeCommand(TransactionalEditingDomain domain) {
        super(domain);
    }

    protected void doExecute() {
        DDiagramSynchronizer diagramSynchronizer = new DDiagramSynchronizer(this._session.getInterpreter(), this._diagram.getDescription(), this._session.getModelAccessor());
        diagramSynchronizer.setDiagram((DSemanticDiagram)this._diagram);
        HashMap edgeToMappingBasedDecoration = new HashMap();
        HashMap edgeToSemanticBasedDecoration = new HashMap();
        DDiagramElementSynchronizer elementSynchronizer = diagramSynchronizer.getElementSynchronizer();
        Map mappingsToEdgeTargets = elementSynchronizer.computeMappingsToEdgeTargets(this._session.getSelectedViewpoints(false));
        DiagramMappingsManager diagramMappingsManager = DiagramMappingsManagerRegistryImpl.INSTANCE.getDiagramMappingsManager(this._session, this._diagram);
        try {
            List<EdgeTarget> sourceNodes = this.getSourceNodes();
            List<EdgeTarget> targetNodes = this.getTargetNodes();
            RefreshIdsHolder refreshIdsHolder = new RefreshIdsHolder();
            for (EdgeTarget sourceEdgeTarget : sourceNodes) {
                for (EdgeTarget targetEdgeTarget : targetNodes) {
                    EdgeMappingQuery edgeMappingQuery = new EdgeMappingQuery(this._mapping);
                    boolean precondition = edgeMappingQuery.evaluatePrecondition((DSemanticDiagram)this._diagram, (DragAndDropTarget)this._diagram, this._session.getInterpreter(), this._target, (DSemanticDecorator)sourceEdgeTarget, (DSemanticDecorator)targetEdgeTarget);
                    if (!precondition) continue;
                    DEdgeCandidate candidate = new DEdgeCandidate(this._mapping, this._target, sourceEdgeTarget, targetEdgeTarget, refreshIdsHolder);
                    elementSynchronizer.createNewEdge(diagramMappingsManager, candidate, mappingsToEdgeTargets, edgeToMappingBasedDecoration, edgeToSemanticBasedDecoration);
                }
            }
        }
        catch (EvaluationException e) {
            e.printStackTrace();
        }
    }

    public List<EdgeTarget> getSourceNodes() throws EvaluationException {
        ArrayList<EdgeTarget> result = new ArrayList<EdgeTarget>();
        Collection sematicSources = new ArrayList<EObject>();
        IInterpreter interpreter = this._session.getInterpreter();
        if (this._isElementBasedEdge) {
            sematicSources = interpreter.evaluateCollection(this._target, this._mapping.getSourceFinderExpression());
        } else {
            sematicSources.add(this._target);
        }
        EList sourceMapping = this._mapping.getSourceMapping();
        for (EObject eObject : sematicSources) {
            List<EdgeTarget> sources = this.getNodesFromDiagram((EList<DiagramElementMapping>)sourceMapping, eObject);
            if (sources.isEmpty()) continue;
            result.addAll(sources);
        }
        return result;
    }

    public List<EdgeTarget> getTargetNodes() throws EvaluationException {
        ArrayList<EdgeTarget> result = new ArrayList<EdgeTarget>();
        IInterpreter interpreter = this._session.getInterpreter();
        Collection sematicTarget = new ArrayList();
        try {
            sematicTarget = interpreter.evaluateCollection(this._target, this._mapping.getTargetFinderExpression());
        }
        catch (EvaluationException evaluationException) {}
        EList targetMapping = this._mapping.getTargetMapping();
        for (EObject eObject : sematicTarget) {
            List<EdgeTarget> targets = this.getNodesFromDiagram((EList<DiagramElementMapping>)targetMapping, eObject);
            if (targets.isEmpty()) continue;
            result.addAll(targets);
        }
        return result;
    }

    private List<EdgeTarget> getNodesFromDiagram(EList<DiagramElementMapping> mapping, EObject semantic) {
        ArrayList<EdgeTarget> result = new ArrayList<EdgeTarget>();
        for (DiagramElementMapping diagramElementMapping : mapping) {
            if (diagramElementMapping instanceof ContainerMapping) {
                EList containers = DDiagramSpecOperations.getContainersFromMapping((DDiagram)this._diagram, (ContainerMapping)((ContainerMapping)diagramElementMapping));
                for (DDiagramElementContainer dDiagramElementContainer : containers) {
                    if (!dDiagramElementContainer.getTarget().equals(semantic)) continue;
                    result.add((EdgeTarget)dDiagramElementContainer);
                }
            }
            if (!(diagramElementMapping instanceof NodeMapping)) continue;
            EList nodes = DDiagramSpecOperations.getNodesFromMapping((DDiagram)this._diagram, (NodeMapping)((NodeMapping)diagramElementMapping));
            for (DNode dNode : nodes) {
                if (!dNode.getTarget().equals(semantic)) continue;
                result.add((EdgeTarget)dNode);
            }
        }
        return result;
    }
}

