/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.build.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.ftask.producer.invocation.ITaskProduction;
import org.eclipse.egf.model.domain.EMFDomain;
import org.eclipse.emf.common.util.EList;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpbuild.Build;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpbuild.Repository;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpbuild.SourceFolder;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpbuild.Trigger;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpbuild.User;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Aspect;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.build.tasks.Messages;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.build.util.BuildVPConfigurationHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.build.util.JavaUtil;

public class CreateRelengPluginTask
implements ITaskProduction {
    public void preExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }

    public void doExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        EList mappedrepositories = new ArrayList();
        String targetlocation = null;
        List<String> sourceFolders = null;
        List<String> cronTrigger = null;
        List<String> scmTrigger = null;
        Map<String, String> users = null;
        Map<String, String> hudsonProperties = null;
        Map<String, String> generationLocation = null;
        String executionEnvironment = (String)productionContext.getInputValue((Object)"execution.environment", String.class);
        if (executionEnvironment == null || "".equals(executionEnvironment)) {
            throw new InvocationException(Messages.GeneratorError_ExecutionEnvironmentNotFound);
        }
        String rootProjectName = (String)productionContext.getInputValue((Object)"root.project.name", String.class);
        if (rootProjectName == null || "".equals(rootProjectName)) {
            throw new InvocationException(Messages.GeneratorError_ProjectNameNotFound);
        }
        EMFDomain model = (EMFDomain)productionContext.getInputValue((Object)"vpdesc.model", EMFDomain.class);
        if (!model.getContent().isEmpty()) {
            Viewpoint viewpoint = (Viewpoint)model.getContent().get(0);
            EList vpAspects = viewpoint.getVP_Aspects();
            for (Aspect aspect : vpAspects) {
                if (!(aspect instanceof Build)) continue;
                Build build = (Build)aspect;
                mappedrepositories = build.getMapped_repositories();
                targetlocation = build.getTarget_platform();
                if (build.getMapped_repositories() != null && !build.getMapped_repositories().isEmpty()) {
                    sourceFolders = BuildVPConfigurationHelper.getSourceFolders((EList<SourceFolder>)((Repository)build.getMapped_repositories().get(0)).getFolders());
                }
                if (build.getHudsonDeployment() == null) break;
                cronTrigger = BuildVPConfigurationHelper.getCronTriggers((EList<Trigger>)build.getHudsonDeployment().getTriggers());
                scmTrigger = BuildVPConfigurationHelper.getScmTriggers((EList<Trigger>)build.getHudsonDeployment().getTriggers());
                users = BuildVPConfigurationHelper.getUsers((EList<User>)build.getHudsonDeployment().getUsers());
                hudsonProperties = BuildVPConfigurationHelper.getHudsonProperties(build.getHudsonDeployment());
                generationLocation = BuildVPConfigurationHelper.getGenerationLocation(build.getHudsonDeployment().getGenerationLocation());
                break;
            }
            if (!mappedrepositories.isEmpty()) {
                String projectId = String.valueOf(rootProjectName) + "." + "releng";
                JavaUtil.createJavaProject(projectId, executionEnvironment, monitor);
                JavaUtil.convertJavaProjectToPlugin(projectId, monitor);
                productionContext.setOutputValue((Object)"target.location", (Object)targetlocation);
                productionContext.setOutputValue((Object)"repository.location", (Object)((Repository)mappedrepositories.get(0)).getLocation());
                productionContext.setOutputValue((Object)"repository.protocol", (Object)((Repository)mappedrepositories.get(0)).getProtocol().getName());
                productionContext.setOutputValue((Object)"source.folders", sourceFolders);
                productionContext.setOutputValue((Object)"cron.triggers", cronTrigger);
                productionContext.setOutputValue((Object)"scm.triggers", scmTrigger);
                productionContext.setOutputValue((Object)"build.users", users);
                productionContext.setOutputValue((Object)"hudson.properties", hudsonProperties);
                productionContext.setOutputValue((Object)"generation.location", generationLocation);
                productionContext.setOutputValue((Object)"releng.project.name", (Object)projectId);
            }
        }
    }

    public void postExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }
}

