/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.as.diagram.expression.helper.sirius;

import org.polarsys.kitalpha.ad.viewpoint.dsl.as.diagram.expression.helper.sirius.IExpressionFormat;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.diagram.expression.helper.sirius.OCLExpressionNotSupported;

public enum ExpressionKind implements IExpressionFormat
{
    QueryLegacy,
    Acceleo_3_x,
    Ocl,
    AQL;


    @Override
    public String format(String expression) {
        if (this.isFormated(expression)) {
            return expression;
        }
        switch (this) {
            case QueryLegacy: {
                return this.getExpressionQueryLegacy(expression);
            }
            case Acceleo_3_x: {
                return this.getExpressionAcceleo3(expression);
            }
            case Ocl: {
                return this.getExpressionOcl(expression);
            }
            case AQL: {
                return this.getExpressionAQL(expression);
            }
        }
        throw new IllegalStateException("Expression kind not supported");
    }

    public String getConcatenationCharacter() {
        switch (this) {
            case QueryLegacy: {
                return "";
            }
            case Acceleo_3_x: 
            case AQL: {
                return "+";
            }
            case Ocl: {
                throw new OCLExpressionNotSupported();
            }
        }
        throw new IllegalStateException("Expression kind not supported");
    }

    @Override
    public boolean isFormated(String expression) {
        switch (this) {
            case QueryLegacy: {
                return this.containsDelimiters(expression, 2, 2);
            }
            case Acceleo_3_x: {
                return this.containsDelimiters(expression, 1, 2);
            }
            case Ocl: {
                return this.containsDelimiters(expression, 4, -1);
            }
            case AQL: {
                return this.containsDelimiters(expression, 4, -1);
            }
        }
        return false;
    }

    public String toString() {
        switch (this) {
            case QueryLegacy: {
                return "QueryLegacy";
            }
            case Acceleo_3_x: {
                return "Acceleo3";
            }
            case Ocl: {
                return "Ocl";
            }
            case AQL: {
                return "AQL";
            }
        }
        throw new IllegalStateException();
    }

    public static ExpressionKind getExpressionKind(String expressionKind) {
        if (expressionKind.equals(QueryLegacy.toString())) {
            return QueryLegacy;
        }
        if (expressionKind.equals(Acceleo_3_x.toString())) {
            return Acceleo_3_x;
        }
        if (expressionKind.equals(Ocl.toString())) {
            return Ocl;
        }
        if (expressionKind.equals(AQL.toString())) {
            return AQL;
        }
        throw new IllegalStateException();
    }

    private String getExpressionAQL(String expression) {
        if (expression.startsWith("aql:")) {
            return expression;
        }
        return "aql:" + expression;
    }

    private String getExpressionQueryLegacy(String expression) {
        if (expression.contains("<%") && expression.contains("%>")) {
            return expression;
        }
        return "<%" + expression + "%>";
    }

    private String getExpressionAcceleo3(String expression) {
        return "[" + expression + "/]";
    }

    private String getExpressionOcl(String expression) {
        throw new OCLExpressionNotSupported();
    }

    private boolean containsDelimiters(String expression, int beginPrefixLenght, int endPrefixLenght) {
        boolean result = false;
        boolean checkExpressionEnd = false;
        if (expression == null || expression.length() < beginPrefixLenght) {
            return false;
        }
        String beginDelimiter = expression.substring(0, beginPrefixLenght);
        switch (this) {
            case QueryLegacy: {
                result = beginDelimiter.equals("<%");
                checkExpressionEnd = true;
                break;
            }
            case Acceleo_3_x: {
                result = beginDelimiter.equals("[");
                checkExpressionEnd = true;
                break;
            }
            case Ocl: {
                result = beginDelimiter.equals("ocl:");
                break;
            }
            case AQL: {
                result = beginDelimiter.equals("aql:");
            }
        }
        if (checkExpressionEnd && endPrefixLenght > 0) {
            String endDelimiter = expression.substring(0, beginPrefixLenght);
            switch (this) {
                case QueryLegacy: {
                    result &= endDelimiter.equals("%>");
                    break;
                }
                case Acceleo_3_x: {
                    result &= endDelimiter.equals("/]");
                    break;
                }
                case Ocl: {
                    result &= true;
                }
            }
        }
        return result;
    }
}

