/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.egf.genchain.diagram.ui.wizard;

import java.util.Set;
import org.eclipse.egf.portfolio.genchain.extension.ExtensionProperties;
import org.eclipse.egf.portfolio.genchain.generationChain.GenerationChain;
import org.eclipse.egf.portfolio.genchain.tools.ui.wizards.EcoreModelPage;
import org.eclipse.egf.portfolio.genchain.tools.ui.wizards.GenerationChainFactory;
import org.eclipse.egf.portfolio.genchain.tools.ui.wizards.Node;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.polarsys.kitalpha.egf.genchain.diagram.message.Messages;
import org.polarsys.kitalpha.egf.genchain.diagram.ui.wizard.KitalphaEcoreModelPage;

public class NewElementWizard
extends Wizard
implements ExtensionProperties {
    private EcoreModelPage ecorePage;
    private final Node model = new Node(0);
    private final GenerationChain generationChain;

    public NewElementWizard(GenerationChain chain) {
        this.generationChain = chain;
    }

    public void addPages() {
        this.ecorePage = new KitalphaEcoreModelPage("ecore", this.generationChain, this.model);
        this.ecorePage.setTitle(Messages.Element_wizard_title);
        this.ecorePage.setDescription(Messages.Element_wizard_content_description);
        this.addPage((IWizardPage)this.ecorePage);
    }

    public boolean performFinish() {
        Session session = SessionManager.INSTANCE.getSession((EObject)this.generationChain);
        if (session != null) {
            TransactionalEditingDomain editingDomain = session.getTransactionalEditingDomain();
            RecordingCommand command = new RecordingCommand(editingDomain){

                protected void doExecute() {
                    NewElementWizard.this.addNewChilds();
                }
            };
            editingDomain.getCommandStack().execute((Command)command);
            return true;
        }
        throw new RuntimeException("Can't update generation chain");
    }

    protected void addNewChilds() {
        Set checkedElements = this.ecorePage.getCheckedElements();
        for (Node container : this.model.getChildren()) {
            GenerationChainFactory.INSTANCE.createExtension(this.generationChain, container, checkedElements);
        }
    }

    static String getModelName(String modelPath) {
        return modelPath.substring(modelPath.lastIndexOf(47) + 1, modelPath.lastIndexOf(46));
    }
}

