/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.desc.operation;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.core.domain.TargetPlatformResourceSet;
import org.eclipse.egf.core.pde.tools.ConvertProjectOperation;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.portfolio.genchain.generationChain.GenerationChain;
import org.eclipse.egf.portfolio.genchain.tools.Activator;
import org.eclipse.egf.portfolio.genchain.tools.ui.actions.CreateFcoreHelper;
import org.eclipse.egf.portfolio.genchain.tools.utils.RunActivityHelper;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.desc.operation.AbstractGenerationOperation;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.event.AbstractGenerationEvent;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.event.listener.IGenerationListener;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.event.manager.GenerationEventManager;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.event.type.ViewpointGenerationEndEvent;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.helper.pde.PDEUtility;

public class GenchainRunOperation
extends AbstractGenerationOperation
implements IGenerationListener {
    private final LocalCreateFcoreAction action = new LocalCreateFcoreAction();

    public GenchainRunOperation(String projectName, String ecoreModelName, String modelsFolder) {
        super(projectName, ecoreModelName, modelsFolder);
        GenerationEventManager.getInstance().addGenerationListener((IGenerationListener)this);
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        this.setMonitor(monitor);
        this.action.createGenerationchainArtefacts();
    }

    @Override
    public String setupModelExtension() {
        return "generationchain";
    }

    public void generationEnd(AbstractGenerationEvent event) {
        if (event instanceof ViewpointGenerationEndEvent) {
            this.action.createFeature();
        }
    }

    public void generationBegin(AbstractGenerationEvent event) {
    }

    class LocalCreateFcoreAction
    extends CreateFcoreHelper {
        private ResourceSet set;
        private GenerationChain generationChain;

        LocalCreateFcoreAction() {
        }

        public void createFeature() {
            URI uri = EcoreUtil.getURI((EObject)this.generationChain);
            TargetPlatformResourceSet gcSet = new TargetPlatformResourceSet();
            this.generationChain = (GenerationChain)gcSet.getEObject(uri, true);
            try {
                if (this.set == null) {
                    this.set = new TargetPlatformResourceSet();
                }
                this.generateFeaturePlugin(this.set, this.generationChain, GenchainRunOperation.this._monitor);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }

        public void createGenerationchainArtefacts() {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(GenchainRunOperation.this._projectName);
            ConvertProjectOperation convertOperation = new ConvertProjectOperation(project, false, false);
            try {
                convertOperation.run(GenchainRunOperation.this._monitor);
            }
            catch (Exception e) {
                Activator.getDefault().logError((Throwable)e);
            }
            URI fcoreURI = GenchainRunOperation.this.getModelUri(true);
            TargetPlatformResourceSet resourceSet = new TargetPlatformResourceSet();
            this.generationChain = (GenerationChain)resourceSet.getResource(fcoreURI, true).getContents().get(0);
            String fcoreRelativePath = "model/" + this.generationChain.getName() + ".fcore";
            String fcoreProjectName = String.valueOf(this.generationChain.getFactoryComponentName()) + ".fc";
            String fcoreOutputPath = String.valueOf(fcoreProjectName) + "/" + fcoreRelativePath;
            try {
                this.setupProject(fcoreProjectName, fcoreRelativePath);
                this.createFcore(this.generationChain, fcoreOutputPath, GenchainRunOperation.this._monitor);
                this.setupGeneratedProject(fcoreProjectName, fcoreRelativePath);
                this.set = this.runFcore(fcoreOutputPath);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }

        protected String computeFcoreOutputPath(GenerationChain generationChain) {
            return String.valueOf(generationChain.getFactoryComponentName()) + ".fc" + this.computeFcoreRelativePath(generationChain);
        }

        private void setupGeneratedProject(String projectName, String fcorePath) throws CoreException {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            try {
                PDEUtility.updatePluginXml((IProject)project, (String)this.getPluginXmlContent(fcorePath));
            }
            catch (InvocationTargetException e1) {
                e1.printStackTrace();
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            ResourcesPlugin.getWorkspace().build(15, GenchainRunOperation.this._monitor);
        }

        protected ResourceSet runFcore(String fcoreOutputPath) throws CoreException {
            URI uri = URI.createPlatformPluginURI((String)fcoreOutputPath, (boolean)false);
            TargetPlatformResourceSet resourceSet = new TargetPlatformResourceSet();
            EObject eObject = (EObject)resourceSet.getResource(uri, true).getContents().get(0);
            try {
                RunActivityHelper.run((Activity)((Activity)eObject), (IProgressMonitor)GenchainRunOperation.this._monitor);
            }
            catch (InvocationException e) {
                throw new CoreException((IStatus)new Status(4, Activator.getDefault().getPluginID(), e.getMessage(), (Throwable)e));
            }
            return resourceSet;
        }

        private String getPluginXmlContent(String fcorePath) {
            String result = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><?eclipse version=\"3.2\"?><plugin>   <extension         point=\"org.eclipse.egf.core.fcore\">     <fcore            id=\"" + fcorePath + "\">" + "      </fcore>" + "   </extension>" + "</plugin>";
            return result;
        }
    }
}

