/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.build.tasks;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.inject.Injector;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.ftask.producer.invocation.ITaskProduction;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.build.setup.BuildDocGeneratorSetup;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.build.tasks.Messages;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.build.templates.GenBuildDocumentation;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.build.util.JavaUtil;

public class CreateBuildDocumentationTask
implements ITaskProduction {
    private Injector injector;
    Set<OutputConfiguration> outputConfigurations = new HashSet<OutputConfiguration>();

    protected IGenerator getCompiler() {
        return (IGenerator)this.injector.getInstance(IGenerator.class);
    }

    public void preExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }

    public void doExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        String repositoryLocation = (String)productionContext.getInputValue((Object)"repository.location", String.class);
        if (repositoryLocation == null || "".equals(repositoryLocation)) {
            throw new InvocationException(Messages.GeneratorError_RepositoryLocationNotFound);
        }
        String repositoryProtocol = (String)productionContext.getInputValue((Object)"repository.protocol", String.class);
        if (repositoryProtocol == null || "".equals(repositoryProtocol)) {
            throw new InvocationException(Messages.GeneratorError_RepositoryProtocolNotFound);
        }
        String rootProjectName = (String)productionContext.getInputValue((Object)"root.project.name", String.class);
        if (rootProjectName == null || "".equals(rootProjectName)) {
            throw new InvocationException(Messages.GeneratorError_ProjectNameNotFound);
        }
        String lvpsShortName = (String)productionContext.getInputValue((Object)"short.name", String.class);
        if (lvpsShortName == null || "".equals(lvpsShortName)) {
            throw new InvocationException(Messages.GeneratorError_ViewpointShortNameNotFound);
        }
        String projectId = String.valueOf(rootProjectName) + "." + "releng";
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectId);
        if (!project.exists()) {
            throw new RuntimeException(Messages.GeneratorError_RelengPluginNotFound);
        }
        IPath location = project.getLocation();
        String buildFilePath = String.valueOf(location.toString()) + "/releng-scripts/" + "build_" + lvpsShortName + "/releng/build.xml";
        this.initOutputConfigurations(projectId, "doc");
        this.doGenerateDocumentation(lvpsShortName, buildFilePath, repositoryLocation, repositoryProtocol);
    }

    private void doGenerateDocumentation(String lvpsShortName, String buildFilePath, String repositoryLocation, String repositoryProtocol) {
        this.injector = new BuildDocGeneratorSetup().createInjectorAndDoEMFRegistration();
        IGenerator instance = this.getCompiler();
        if (instance == null) {
            throw new RuntimeException(Messages.GeneratorError_UnboundGenerator);
        }
        GenBuildDocumentation genDoc = (GenBuildDocumentation)instance;
        IFileSystemAccess fsa = this.getConfiguredFileSystemAccess();
        genDoc.setRepositoryURL(this.reconcile(repositoryProtocol, repositoryLocation));
        genDoc.setViewpointShortName(lvpsShortName);
        genDoc.setBuildFilePath(buildFilePath);
        genDoc.doGenerate(null, fsa);
    }

    private String reconcile(String repositoryProtocol, String repositoryLocation) {
        if (repositoryProtocol.equals("git")) {
            return "git http://" + repositoryLocation;
        }
        if (repositoryProtocol.equals("svn")) {
            return "svn://" + repositoryLocation;
        }
        if (repositoryProtocol.equals("svnssh")) {
            return "svn+ssh://" + repositoryLocation;
        }
        throw new RuntimeException(Messages.GeneratorError_RepositoryProtocolNotFound);
    }

    private void initOutputConfigurations(String projectName, String folderName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project.exists()) {
            this.addOutputConfiguration(project, folderName);
        }
    }

    protected IFileSystemAccess getConfiguredFileSystemAccess() {
        JavaIoFileSystemAccess configuredFileSystemAccess = (JavaIoFileSystemAccess)this.injector.getInstance(JavaIoFileSystemAccess.class);
        configuredFileSystemAccess.setOutputConfigurations(this.getOutputConfigurations());
        for (OutputConfiguration current : this.outputConfigurations) {
            String name = current.getName();
            String outputDirectory = current.getOutputDirectory();
            configuredFileSystemAccess.setOutputPath(name, outputDirectory);
        }
        return configuredFileSystemAccess;
    }

    protected Map<String, OutputConfiguration> getOutputConfigurations() {
        Set<OutputConfiguration> configurations = this.getCurrentOutputConfigurations();
        return Maps.uniqueIndex(configurations, (Function)new Function<OutputConfiguration, String>(){

            public String apply(OutputConfiguration from) {
                return from.getName();
            }
        });
    }

    protected Set<OutputConfiguration> getCurrentOutputConfigurations() {
        return this.outputConfigurations;
    }

    protected void addOutputConfiguration(IProject project, String folderName) {
        IFolder folderPath = JavaUtil.createFolder(project.getName(), folderName);
        OutputConfiguration targetOutput = new OutputConfiguration("DEFAULT_OUTPUT");
        targetOutput.setDescription(project.getName());
        targetOutput.setOutputDirectory(folderPath.getLocation().toString());
        targetOutput.setOverrideExistingResources(true);
        targetOutput.setCreateOutputDirectory(true);
        targetOutput.setCleanUpDerivedResources(true);
        targetOutput.setSetDerivedProperty(true);
        this.outputConfigurations.add(targetOutput);
    }

    public void postExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }
}

