/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.emde.diagram.services;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.sirius.common.tools.api.editing.EditingDomainFactoryService;

public class ReadOnlyResourceManager {
    private static final TransactionalEditingDomain editingDomain = EditingDomainFactoryService.INSTANCE.getEditingDomainFactory().createEditingDomain();
    private static Map<Resource, Boolean> resourceToReadOnlyMap = ((AdapterFactoryEditingDomain)editingDomain).getResourceToReadOnlyMap();
    private static Map<EditPart, Collection<Resource>> resourceRegistry = new HashMap<EditPart, Collection<Resource>>();
    public static Map<EditPart, EditPartListener> listenerRegistry = new HashMap<EditPart, EditPartListener>();

    public static void handler(DiagramEditPart editPart, Resource currentResource, Resource addedResource) {
        Resource resourceInMap = ReadOnlyResourceManager.findResource(resourceToReadOnlyMap, addedResource);
        URI currentURI = currentResource.getURI();
        URI addedURI = resourceInMap.getURI();
        if (!currentURI.isPlatformPlugin() && !currentURI.path().toString().equals(addedURI.path().toString()) && listenerRegistry.get(editPart) != null) {
            resourceToReadOnlyMap.put(resourceInMap, true);
            UniqueEList collection = resourceRegistry.get(editPart);
            if (collection == null) {
                collection = new UniqueEList();
            }
            collection.add((Resource)resourceInMap);
            resourceRegistry.put((EditPart)editPart, (Collection<Resource>)collection);
        }
        if (listenerRegistry.get(editPart) == null) {
            EditPartListener.Stub editPartListener = new EditPartListener.Stub(){

                public void partDeactivated(EditPart editpart) {
                    Collection collection = (Collection)resourceRegistry.get(editpart);
                    if (collection != null && collection.size() > 0) {
                        for (Resource resource : collection) {
                            resourceToReadOnlyMap.remove(resource);
                        }
                    }
                }
            };
            editPart.addEditPartListener((EditPartListener)editPartListener);
            listenerRegistry.put((EditPart)editPart, (EditPartListener)editPartListener);
        }
    }

    private static Resource findResource(Map<Resource, Boolean> map, Resource resource) {
        String path = resource.getURI().path().toString();
        for (Resource r : map.keySet()) {
            if (!r.getURI().path().toString().equals(path)) continue;
            return r;
        }
        return resource;
    }
}

