/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.ecore.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class AIRDDiagramGeneratorHelper {
    private static final String AIRD = ".aird";
    private static final String GEN_DIAGRAM = "genDiagram_";
    public static final ILabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)new EcoreItemProviderAdapterFactory());
    private static final String TITLE = "Selection dialog";
    private static final String MESSAGE = "Select elements for generating documentation";

    public static URI generateURI(IPath path) {
        URI airdURI = URI.createPlatformResourceURI((String)(String.valueOf(path.toString()) + "/" + GEN_DIAGRAM + System.currentTimeMillis() + AIRD), (boolean)true);
        return airdURI;
    }

    public static URI getExistedURI(IPath path) {
        try {
            IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
            if (folder.exists()) {
                IResource[] members;
                IResource[] iResourceArray = members = folder.members();
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    String fileName = resource.getName();
                    if (fileName.startsWith(GEN_DIAGRAM) && fileName.endsWith(AIRD)) {
                        String pathName = resource.getFullPath().toString();
                        return URI.createPlatformResourceURI((String)pathName, (boolean)false);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void generateDiagram(Viewpoint viewpoint, EObject semanticObject, boolean canSelect) {
        HashMap<DiagramDescription, Boolean> initOptionMap = new HashMap<DiagramDescription, Boolean>();
        for (Object o : viewpoint.getOwnedRepresentations()) {
            if (!(o instanceof DiagramDescription)) continue;
            DiagramDescription description = (DiagramDescription)o;
            initOptionMap.put(description, description.isInitialisation());
            description.setInitialisation(true);
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (canSelect) {
            Shell shell = new Shell();
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, labelProvider);
            List<EObject> list = AIRDDiagramGeneratorHelper.getCandidateList(semanticObject);
            dialog.setElements(list.toArray());
            dialog.setTitle(TITLE);
            dialog.setMessage(MESSAGE);
            dialog.setMultipleSelection(true);
            if (dialog.open() == 0) {
                Object[] selection;
                Object[] objectArray = selection = dialog.getResult();
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    DialectManager.INSTANCE.initRepresentations(viewpoint, (EObject)object, (IProgressMonitor)monitor);
                    ++n2;
                }
            }
            shell.dispose();
        } else {
            DialectManager.INSTANCE.initRepresentations(viewpoint, semanticObject, (IProgressMonitor)monitor);
        }
        for (DiagramDescription description : initOptionMap.keySet()) {
            description.setInitialisation(((Boolean)initOptionMap.get(description)).booleanValue());
        }
    }

    private static List<EObject> getCandidateList(EObject semanticObject) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        TreeIterator iterator = semanticObject.eAllContents();
        while (iterator.hasNext()) {
            EObject next = (EObject)iterator.next();
            if (!AIRDDiagramGeneratorHelper.isQualified(next)) continue;
            result.add(next);
        }
        return result;
    }

    public static boolean isQualified(EObject next) {
        return next instanceof EClass;
    }
}

