/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.wizards;

import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.wizards.Messages;

public abstract class AbstractFileCreationPage
extends WizardNewFileCreationPage {
    protected IProject viewpointProject;

    public AbstractFileCreationPage(IStructuredSelection selection) {
        super(Messages.DefaultFileCreationPage_Title, selection);
        this.setTitle(Messages.DefaultFileCreationPage_Title);
        this.setDescription(Messages.DefaultFileCreationPage_Description);
        this.setFileExtension("vptext");
        this.loadViewpointProject(selection);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.initializeProperties();
    }

    public abstract void initializeProperties();

    private void loadViewpointProject(IStructuredSelection selection) {
        TreeSelection currentSelection = (TreeSelection)selection;
        for (Object object : currentSelection) {
            IResource selectedResource = null;
            if (object instanceof IResource) {
                selectedResource = (IResource)object;
            } else if (object instanceof IAdaptable) {
                selectedResource = (IResource)((IAdaptable)object).getAdapter(IResource.class);
            }
            if (selectedResource == null || selectedResource.getType() != 2 && selectedResource.getType() != 1) continue;
            this.setViewpointProject(selectedResource.getProject());
        }
    }

    protected boolean validatePage() {
        boolean apriori = super.validatePage();
        String fileName = this.getFileName();
        Pattern pattern = Pattern.compile("(.*).(ui|conf|data|spec|build|diagram|services|activityexplorer).vptext");
        boolean fileMatches = pattern.matcher(fileName).matches();
        return apriori && fileMatches;
    }

    public IProject getViewpointProject() {
        return this.viewpointProject;
    }

    public void setViewpointProject(IProject viewpointProject) {
        this.viewpointProject = viewpointProject;
    }
}

