/*******************************************************************************
 * Copyright (c) 2014 Thales Global Services S.A.S.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *  Thales Global Services S.A.S - initial API and implementation
 ******************************************************************************/

package org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.generators.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.resources.ResourceHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.action.popup.LaunchVPGenerationAndBuildAction;

import com.google.inject.Inject;


/**
 * 
 * @author Amine Lajmi
 *
 */
public class GenerateViewpointEditorAction implements IEditorActionDelegate{
		
	@Inject
	private XtextEditor currentEditor;
	
	ISelection currentSelection;

	LaunchVPGenerationAndBuildAction delegate;
	
	public GenerateViewpointEditorAction() {
		super();
		delegate = new LaunchVPGenerationAndBuildAction();	
	}
		
	public void selectionChanged(IAction action, ISelection selection) {
		if (currentEditor != null && currentEditor instanceof XtextEditor && currentEditor.getEditorInput()!=null) {
			IFile file = (IFile) currentEditor.getEditorInput().getAdapter(IFile.class);
			IFile standalone = ResourceHelper.getStandaloneFile(file);
			if (standalone!=null) {
				currentSelection = new StructuredSelection(standalone);
				delegate.selectionChanged(action, currentSelection);
			}
		}
	}

	public void run(IAction action) {
		if (currentEditor != null) {
			if (currentEditor instanceof XtextEditor) {
				IFile file = (IFile) currentEditor.getEditorInput().getAdapter(IFile.class);
				IFile standalone = ResourceHelper.getStandaloneFile(file);
				if (standalone!=null) {
					currentSelection = new StructuredSelection(standalone);
					delegate.selectionChanged(action, currentSelection);
					delegate.run(action);
				}
			}
		}
	}

	public void setActiveEditor(IAction action, IEditorPart targetEditor) {
		if (targetEditor instanceof XtextEditor) {
			currentEditor = (XtextEditor) targetEditor;
		}
	}
}
