/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.conf.desc.data;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.egf.portfolio.genchain.generationChain.EmfGeneration;
import org.eclipse.egf.portfolio.genchain.generationChain.GenerationChain;
import org.eclipse.egf.portfolio.genchain.generationChain.GenerationElement;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.configuration.VpDslConfigurationHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.common.manager.VpdslDescriptionModelManager;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.conf.element.IGenerationElementInnerConfiguration;

public class EMFGenerationElementConfiguration
implements IGenerationElementInnerConfiguration {
    private boolean genModel;
    private boolean genEdit;
    private boolean genEditor;
    private boolean genTest;
    private boolean genJavaDoc;

    public EMFGenerationElementConfiguration() {
        Viewpoint viewpoint = VpdslDescriptionModelManager.INSTANCE.getVpDescriptionElement();
        this.genModel = VpDslConfigurationHelper.getGenerateModel((Object)viewpoint);
        this.genEdit = VpDslConfigurationHelper.getGenerateEdit((Object)viewpoint);
        this.genEditor = VpDslConfigurationHelper.getGenerateEditor((Object)viewpoint);
        this.genTest = VpDslConfigurationHelper.getGenerateTest((Object)viewpoint);
        this.genJavaDoc = VpDslConfigurationHelper.getGenerateJavaDoc((Object)viewpoint);
    }

    private void refreshOptions() {
        Viewpoint viewpoint = VpdslDescriptionModelManager.INSTANCE.getVpDescriptionElement();
        this.genModel = VpDslConfigurationHelper.getGenerateModel((Object)viewpoint);
        this.genEdit = VpDslConfigurationHelper.getGenerateEdit((Object)viewpoint);
        this.genEditor = VpDslConfigurationHelper.getGenerateEditor((Object)viewpoint);
        this.genTest = VpDslConfigurationHelper.getGenerateTest((Object)viewpoint);
        this.genJavaDoc = VpDslConfigurationHelper.getGenerateJavaDoc((Object)viewpoint);
    }

    public Class<? extends GenerationElement> getElementClass() {
        return EmfGeneration.class;
    }

    public void configure(GenerationElement element) {
        this.refreshOptions();
        EmfGeneration emfElement = null;
        if (!(element instanceof EmfGeneration)) {
            throw new IllegalArgumentException(String.valueOf(element.getName()) + " Generation element can't be configured by EMFGenerationElementConfiguration");
        }
        emfElement = (EmfGeneration)element;
        emfElement.setGenerateModel(this.genModel);
        emfElement.setGenerateEdit(this.genEdit);
        emfElement.setGenerateEditor(this.genEditor);
        emfElement.setGenerateTest(this.genTest);
        emfElement.setGenerateJavadoc(this.genJavaDoc);
    }

    public boolean isRelevant(GenerationChain generationchain, GenerationElement element) {
        String editPluginName;
        this.refreshOptions();
        if (!(this.genModel || this.genEdit || this.genEditor || this.genTest || this.genJavaDoc)) {
            return false;
        }
        boolean relevant = true;
        EmfGeneration emfGeneration = (EmfGeneration)element;
        String modelPluginName = emfGeneration.getPluginName();
        String string = editPluginName = modelPluginName != null ? String.valueOf(modelPluginName) + ".edit" : "";
        if (!this.genModel) {
            IProject modelProject = null;
            if (modelPluginName != null && modelPluginName.length() > 0) {
                modelProject = ResourcesPlugin.getWorkspace().getRoot().getProject(modelPluginName);
            }
            relevant &= modelProject != null && modelProject.exists();
        }
        if (!this.genEdit) {
            IProject editProject = null;
            if (editPluginName != null && editPluginName.length() > 0) {
                editProject = ResourcesPlugin.getWorkspace().getRoot().getProject(editPluginName);
            }
            relevant &= editProject != null && editProject.exists();
        }
        return relevant;
    }
}

