/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.validation.constraint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.validation.exception.NoFeatureNameProvided;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.validation.extension.ICoreConstraintContribution;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.validation.extension.VPElementValidatorsManager;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.validation.message.Messages;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.NamedElement;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.ShortNamedElement;

public abstract class VpDescAbstractModelConstraint
extends AbstractModelConstraint {
    protected List<String> brothersEStucturalFeature = new ArrayList<String>();
    protected String eStructuralFeatureName;

    protected abstract void setEStructuralFeatureName(EObject var1);

    protected abstract String getMessageToDisplay(EObject var1);

    protected abstract boolean isValidData(EObject var1, Object var2);

    protected abstract boolean isObjectInScope(Object var1);

    protected abstract boolean getDisplayContainerInformations(Object var1);

    protected void init(EObject object) {
        this.eStructuralFeatureName = "";
        this.brothersEStucturalFeature.clear();
        this.registerEStructuralFeature(object);
    }

    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        boolean objectInScope = this.isObjectInScope(eObj);
        boolean extensionObjectInScope = this.isObjectInExtensionsScope(eObj, ctx.getCurrentConstraintId());
        if (objectInScope || extensionObjectInScope) {
            this.init(eObj);
            EMFEventType eType = ctx.getEventType();
            if (eType == EMFEventType.NULL) {
                List<String> brothers;
                if (extensionObjectInScope && (brothers = this.getBrothersSet(eObj, ctx.getCurrentConstraintId())) != null && brothers.size() > 0) {
                    this.brothersEStucturalFeature = brothers;
                }
                ArrayList<EObject> dataToCheck = null;
                ArrayList<EObject> dataToCheckList = new ArrayList<EObject>();
                if (this.brothersEStucturalFeature != null && !this.brothersEStucturalFeature.isEmpty()) {
                    for (String current : this.brothersEStucturalFeature) {
                        Object currentData;
                        EStructuralFeature feature = eObj.eContainer().eClass().getEStructuralFeature(current);
                        if (feature == null || (currentData = eObj.eContainer().eGet(feature)) == null) continue;
                        if (currentData instanceof EList) {
                            dataToCheckList.addAll((Collection<EObject>)((EList)currentData));
                        }
                        if (!(currentData instanceof EObject)) continue;
                        dataToCheckList.add((EObject)currentData);
                    }
                    dataToCheck = dataToCheckList;
                } else {
                    dataToCheck = eObj.eGet(eObj.eClass().getEStructuralFeature(this.eStructuralFeatureName));
                }
                if (!this.isValidData(eObj, dataToCheck)) {
                    return ctx.createFailureStatus(new Object[]{this.getMessageToDisplay(eObj)});
                }
            }
        }
        return ctx.createSuccessStatus();
    }

    private List<String> getBrothersSet(EObject object, String currentConstraintID) {
        List<ICoreConstraintContribution> list = VPElementValidatorsManager.getValidatorFor(currentConstraintID);
        if (list == null || list.size() == 0) {
            return null;
        }
        ArrayList<String> additionalSRF = new ArrayList<String>();
        for (ICoreConstraintContribution vpElementValidator : list) {
            List<String> additional;
            if (!vpElementValidator.isObjectInScope(object) || (additional = vpElementValidator.brothersEStructuralFeatures()) == null || additional.size() <= 0) continue;
            additionalSRF.addAll(additional);
        }
        return additionalSRF;
    }

    protected boolean isObjectInExtensionsScope(EObject object, String currentConstraintID) {
        List<ICoreConstraintContribution> list = VPElementValidatorsManager.getValidatorFor(currentConstraintID);
        if (list == null || list.size() == 0) {
            return false;
        }
        for (ICoreConstraintContribution vpElementValidator : list) {
            if (!vpElementValidator.isObjectInScope(object)) continue;
            return true;
        }
        return false;
    }

    private void registerEStructuralFeature(EObject eObject) {
        this.setEStructuralFeatureName(eObject);
        if (this.eStructuralFeatureName == null || this.eStructuralFeatureName.trim().length() == 0) {
            try {
                throw new NoFeatureNameProvided();
            }
            catch (NoFeatureNameProvided e) {
                e.printStackTrace();
            }
        }
    }

    protected String getElementName(EObject eObject) {
        String result = Messages.bind((String)Messages.Validation_NoName, (Object)eObject.eClass().getName());
        String name = ((NamedElement)eObject).getName();
        return !(eObject instanceof NamedElement) || !this.isNotEmpty(name) ? result : name;
    }

    protected String getElementShortName(EObject eObject) {
        String result = Messages.bind((String)Messages.Validation_NoName, (Object)eObject.eClass().getName());
        String short_name = ((ShortNamedElement)eObject).getShortName();
        return this.isNotEmpty(short_name) ? short_name : result;
    }

    protected boolean isNotEmpty(String data) {
        return data != null && data.trim().length() != 0;
    }
}

