/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.report.ui.views;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.polarsys.kitalpha.report.model.LogEntry;
import org.polarsys.kitalpha.report.ui.description.ReportsUI;

public class ReportLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public String getColumnText(Object element, int columnIndex) {
        String result = "";
        if (element instanceof LogEntry) {
            LogEntry logEntry = (LogEntry)element;
            switch (columnIndex) {
                case 0: {
                    result = logEntry.getMessage();
                    break;
                }
                case 1: {
                    Date date = logEntry.getDate();
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                    result = dateFormat.format(date);
                }
            }
        }
        return result;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image image = ReportsUI.getImage(((LogEntry)element).getSeverity());
        return columnIndex == 0 ? image : null;
    }
}

