/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.config;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Property;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.edit.provider.ViewpointEditPlugin;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.tools.model.ViewpointElement;
import org.polarsys.kitalpha.ad.viewpoint.handlers.IElementHandler;
import org.polarsys.kitalpha.ad.viewpoint.ui.Activator;
import org.polarsys.kitalpha.ad.viewpoint.ui.Messages;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.editing.ComboStringEditingSupport;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.editing.PropertyTypeEditingSupport;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.editing.StringEditingSupport;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.AbstractTab;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.GenericHandlerContentProvider;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.ResourceTableSorter;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.config.ConfigurationLabelProvider;
import org.polarsys.kitalpha.ad.viewpoint.utils.ElementHelper;

public class ConfigurationTab
extends AbstractTab {
    private static final String VALUE_COLUMN = "value";
    private static final String NAME_COLUMN = "name";
    private static final String DESCRIPTION_COLUMN = "description";
    private TableViewer configViewer;
    private Button addBtn;
    private Button deleteBtn;
    private ComboStringEditingSupport nameEditingSupport;

    public ConfigurationTab() {
        super(new ConfigurationLabelProvider());
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.configViewer;
    }

    @Override
    public void createTab(FormToolkit toolkit, CTabFolder folder) {
        Composite composite = this.createTab(toolkit, folder, Messages.ConfigurationTab_title, ViewpointEditPlugin.INSTANCE.getImage("full/obj16/Property"));
        GridLayout clayout = new GridLayout();
        clayout.numColumns = 2;
        composite.setLayout((Layout)clayout);
        this.configViewer = new TableViewer(composite, 67584);
        final Table table = this.configViewer.getTable();
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        AbstractTab.SelectionListener2 headerListener = new AbstractTab.SelectionListener2(this){

            @Override
            public void doWidgetSelected(SelectionEvent e) {
                TableColumn newSortColumn;
                TableColumn currentSortColumn = table.getSortColumn();
                if (currentSortColumn.equals(newSortColumn = (TableColumn)e.getSource())) {
                    int sortDirection = table.getSortDirection();
                    table.setSortDirection(sortDirection == 128 ? 1024 : 128);
                } else {
                    table.setSortColumn(newSortColumn);
                    table.setSortDirection(1024);
                }
                ConfigurationTab.this.configViewer.refresh();
            }
        };
        TableViewerColumn nameColumn = new TableViewerColumn(this.configViewer, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 90, true));
        nameColumn.getColumn().addSelectionListener((SelectionListener)headerListener);
        nameColumn.getColumn().setText(Messages.ConfigurationTab_column_name_label);
        nameColumn.getColumn().setResizable(true);
        nameColumn.getColumn().setData((Object)0);
        this.nameEditingSupport = new ComboStringEditingSupport(this.configViewer, Property.class, NAME_COLUMN);
        nameColumn.setEditingSupport((EditingSupport)this.register(this.nameEditingSupport));
        TableViewerColumn typeColumn = new TableViewerColumn(this.configViewer, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 150, true));
        typeColumn.getColumn().addSelectionListener((SelectionListener)headerListener);
        typeColumn.getColumn().setText(Messages.ConfigurationTab_column_type_label);
        typeColumn.getColumn().setResizable(true);
        typeColumn.getColumn().setData((Object)1);
        typeColumn.setEditingSupport((EditingSupport)this.register(new PropertyTypeEditingSupport(this.configViewer)));
        TableViewerColumn valueColumn = new TableViewerColumn(this.configViewer, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 150, true));
        valueColumn.getColumn().addSelectionListener((SelectionListener)headerListener);
        valueColumn.getColumn().setText(Messages.ConfigurationTab_column_value_label);
        valueColumn.getColumn().setResizable(true);
        valueColumn.getColumn().setData((Object)2);
        valueColumn.setEditingSupport((EditingSupport)this.register(new StringEditingSupport(this.configViewer, Property.class, VALUE_COLUMN)));
        TableViewerColumn descColumn = new TableViewerColumn(this.configViewer, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(6, 150, true));
        descColumn.getColumn().addSelectionListener((SelectionListener)headerListener);
        descColumn.getColumn().setText(Messages.ConfigurationTab_column_desc_label);
        descColumn.getColumn().setResizable(true);
        descColumn.getColumn().setData((Object)3);
        descColumn.setEditingSupport((EditingSupport)this.register(new StringEditingSupport(this.configViewer, Property.class, DESCRIPTION_COLUMN)));
        table.setSortColumn(nameColumn.getColumn());
        table.setSortDirection(1024);
        this.configViewer.setColumnProperties(new String[]{NAME_COLUMN, VALUE_COLUMN, DESCRIPTION_COLUMN});
        this.configViewer.setContentProvider((IContentProvider)GenericHandlerContentProvider.INSTANCE);
        this.configViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.configViewer.setSorter((ViewerSorter)new ResourceTableSorter());
        Composite btnBar = toolkit.createComposite(composite);
        btnBar.setLayout((Layout)new GridLayout());
        this.addBtn = toolkit.createButton(btnBar, "", 8);
        this.addBtn.setToolTipText(Messages.ConfigurationTab_add_tooltip);
        this.addBtn.setImage(Activator.getDefault().getImage("icons/add.gif"));
        this.addBtn.addSelectionListener((SelectionListener)new AbstractTab.SelectionListener2(this){

            @Override
            public void doWidgetSelected(SelectionEvent e) {
                String computeNewName = ElementHelper.computeNewName((IElementHandler)ConfigurationTab.this.modelManager.getConfigurationHandler(), (String)(String.valueOf(ConfigurationTab.this.viewpoint.getId()) + ".property"));
                ConfigurationTab.this.getModelManager().getConfigurationHandler().createProperty(computeNewName);
            }
        });
        this.deleteBtn = toolkit.createButton(btnBar, "", 8);
        this.deleteBtn.setToolTipText(Messages.ConfigurationTab_delete_tooltip);
        this.deleteBtn.setImage(Activator.getDefault().getImage("icons/delete.gif"));
        this.deleteBtn.setEnabled(false);
        this.deleteBtn.addSelectionListener((SelectionListener)new AbstractTab.SelectionListener2(this){

            @Override
            public void doWidgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ConfigurationTab.this.configViewer.getSelection();
                ArrayList<Property> actions = new ArrayList<Property>();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof Property) {
                        actions.add((Property)obj);
                    }
                    ++n2;
                }
                ConfigurationTab.this.modelManager.getConfigurationHandler().removeProperties(actions);
            }
        });
        this.configViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConfigurationTab.this.updateButtons((IStructuredSelection)event.getSelection());
            }
        });
    }

    @Override
    public void init() {
        this.configViewer.setInput((Object)this.modelManager.getConfigurationHandler());
        this.workspaceHasChanged();
    }

    @Override
    public void workspaceHasChanged() {
        super.workspaceHasChanged();
        this.configViewer.refresh();
        List values = ElementHelper.getNamesFromParents((IElementHandler)this.modelManager.getConfigurationHandler());
        this.nameEditingSupport.setItems(values.toArray(new String[values.size()]));
        this.updateButtons((IStructuredSelection)this.configViewer.getSelection());
    }

    private void updateButtons(IStructuredSelection selection) {
        boolean readOnly = this.getModelManager().getResourceManager().isReadOnly();
        this.addBtn.setEnabled(!readOnly);
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (!this.modelManager.getConfigurationHandler().isRemovable((ViewpointElement)((Property)obj))) {
                this.deleteBtn.setEnabled(false);
                return;
            }
            ++n2;
        }
        this.deleteBtn.setEnabled(!readOnly && !selection.isEmpty());
    }
}

