/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.massactions.visualize.notification;

import java.util.Collection;
import java.util.EventListener;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.kitalpha.massactions.core.notification.MAConnector;
import org.polarsys.kitalpha.massactions.visualize.helpers.container.UnfoldedRowObject;
import org.polarsys.kitalpha.massactions.visualize.unfold.MVPerspectiveManager;

public class MVConnector
extends MAConnector {
    protected MVPerspectiveManager perspectiveManager;

    public MVConnector(MVPerspectiveManager perspectiveManager) {
        this.perspectiveManager = perspectiveManager;
    }

    public EventListener installListener(EObject element) {
        if (element instanceof UnfoldedRowObject) {
            return null;
        }
        return super.installListener(element);
    }

    protected MAConnector.LockStatusChangedListener createLockStatusChangedListener() {
        return new MVLockStatusChangedListener();
    }

    public class MVLockStatusChangedListener
    extends MAConnector.LockStatusChangedListener {
        public MVLockStatusChangedListener() {
            super((MAConnector)MVConnector.this);
        }

        public void notifyIsLocked(EObject instance) {
            if (MVConnector.this.perspectiveManager.isFolded()) {
                super.notifyIsLocked(instance);
            } else {
                Collection<EObject> unfoldedData = MVConnector.this.perspectiveManager.getUnfoldedObjectsForRoot(instance);
                MVConnector.this.list.multipleElementsChanged(unfoldedData);
            }
        }

        public void notifyIsReleased(EObject instance) {
            if (MVConnector.this.perspectiveManager.isFolded()) {
                super.notifyIsReleased(instance);
            } else {
                Collection<EObject> unfoldedData = MVConnector.this.perspectiveManager.getUnfoldedObjectsForRoot(instance);
                MVConnector.this.list.multipleElementsChanged(unfoldedData);
            }
        }

        public void notifyIsLocked(Collection<EObject> instances) {
            if (MVConnector.this.perspectiveManager.isFolded()) {
                super.notifyIsLocked(instances);
            } else {
                Set unfoldedData = instances.stream().flatMap(o -> MVConnector.this.perspectiveManager.getUnfoldedObjectsForRoot((EObject)o).stream()).collect(Collectors.toSet());
                MVConnector.this.list.multipleElementsChanged(unfoldedData);
            }
        }

        public void notifyIsReleased(Collection<EObject> instances) {
            if (MVConnector.this.perspectiveManager.isFolded()) {
                super.notifyIsReleased(instances);
            } else {
                Set unfoldedData = instances.stream().flatMap(o -> MVConnector.this.perspectiveManager.getUnfoldedObjectsForRoot((EObject)o).stream()).collect(Collectors.toSet());
                MVConnector.this.list.multipleElementsChanged(unfoldedData);
            }
        }
    }
}

