/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.services;

import java.util.Objects;
import org.polarsys.kitalpha.doc.gen.business.core.util.EscapeChars;

public class IndexItem
implements Comparable<IndexItem> {
    private final String conceptName;
    private final String conceptType;
    private final String iconTag;
    private final String linkTagTowardPage;
    private final String fileName;
    private final String escapedForHTMLConceptName;

    public IndexItem(String conceptName, String conceptType, String iconTag, String linkTagTowardPage, String fileName) {
        this.conceptName = conceptName;
        this.conceptType = conceptType;
        this.iconTag = iconTag;
        this.linkTagTowardPage = linkTagTowardPage;
        this.fileName = fileName;
        this.escapedForHTMLConceptName = EscapeChars.forHTML(conceptName);
    }

    public String getConceptName() {
        return this.conceptName;
    }

    public String getIconTag() {
        return this.iconTag;
    }

    public String getLinkTagTowardPageElement() {
        return this.linkTagTowardPage;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getConceptType() {
        return this.conceptType;
    }

    public String getEscapedForHTMLConceptName() {
        return this.escapedForHTMLConceptName;
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof IndexItem) {
            IndexItem item = (IndexItem)arg0;
            return this.getConceptName().equalsIgnoreCase(item.getConceptName()) && this.getIconTag().equalsIgnoreCase(item.getIconTag()) && this.getLinkTagTowardPageElement().equalsIgnoreCase(item.getLinkTagTowardPageElement()) && this.getFileName().equalsIgnoreCase(item.getFileName());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.getConceptName()) + Objects.hashCode(this.getIconTag()) + Objects.hashCode(this.getLinkTagTowardPageElement()) + Objects.hashCode(this.getFileName());
    }

    @Override
    public int compareTo(IndexItem arg0) {
        return this.getConceptName().compareTo(arg0.getConceptName());
    }
}

